/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.List;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.SinglePhaseCommitForPessimisticCachesTest")
public class SinglePhaseCommitForPessimisticCachesTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = SinglePhaseCommitForPessimisticCachesTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        c.fluent().hash().numOwners(Integer.valueOf(3));
        c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    public void testSinglePhaseCommit() throws Exception {
        Object k0_1 = this.getKeyForCache(0);
        Object k0_2 = this.getKeyForCache(0);
        List members = this.advancedCache(0).getRpcManager().getTransport().getMembers();
        assert (this.advancedCache(0).getDistributionManager().locate(k0_1).containsAll(members));
        assert (this.advancedCache(0).getDistributionManager().locate(k0_2).containsAll(members));
        TxCountInterceptor interceptor0 = new TxCountInterceptor();
        TxCountInterceptor interceptor1 = new TxCountInterceptor();
        this.advancedCache(0).addInterceptor((CommandInterceptor)interceptor0, 1);
        this.advancedCache(1).addInterceptor((CommandInterceptor)interceptor1, 2);
        this.tm(2).begin();
        this.cache(2).put(k0_1, (Object)"v");
        this.cache(2).put(k0_2, (Object)"v");
        this.tm(2).commit();
        Assert.assertEquals((int)interceptor0.lockCount, (int)2);
        Assert.assertEquals((int)interceptor1.lockCount, (int)2);
        Assert.assertEquals((int)interceptor0.prepareCount, (int)1);
        Assert.assertEquals((int)interceptor1.prepareCount, (int)1);
        Assert.assertEquals((int)interceptor0.commitCount, (int)0);
        Assert.assertEquals((int)interceptor1.commitCount, (int)0);
    }

    public static class TxCountInterceptor
    extends CommandInterceptor {
        public volatile int prepareCount;
        public volatile int commitCount;
        public volatile int lockCount;
        public volatile int putCount;
        public volatile int getCount;

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            ++this.prepareCount;
            return super.visitPrepareCommand(ctx, command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            ++this.commitCount;
            return super.visitCommitCommand(ctx, command);
        }

        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            ++this.lockCount;
            return super.visitLockControlCommand(ctx, command);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            ++this.putCount;
            return super.visitPutKeyValueCommand(ctx, command);
        }

        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            ++this.getCount;
            return super.visitGetKeyValueCommand(ctx, command);
        }
    }
}

