/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.InvalidatedMarshalledValueTest")
public class InvalidatedMarshalledValueTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration invlSync = InvalidatedMarshalledValueTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_SYNC);
        invlSync.setUseLazyDeserialization(true);
        this.createClusteredCaches(2, "invlSync", invlSync);
        Cache cache1 = this.cache(0, "invlSync");
        Cache cache2 = this.cache(1, "invlSync");
        this.assertMarshalledValueInterceptorPresent(cache1);
        this.assertMarshalledValueInterceptorPresent(cache2);
    }

    private void assertMarshalledValueInterceptorPresent(Cache c) {
        InterceptorChain ic1 = TestingUtil.extractComponent(c, InterceptorChain.class);
        assert (ic1.containsInterceptorType(MarshalledValueInterceptor.class));
    }

    public void testModificationsOnSameCustomKey() {
        Cache cache1 = this.cache(0, "invlSync");
        Cache cache2 = this.cache(1, "invlSync");
        InvalidatedPojo key = new InvalidatedPojo();
        cache2.put((Object)key, (Object)"1");
        cache1.put((Object)key, (Object)"2");
        this.assertSerializationCounts(5, 0);
        cache1.put((Object)key, (Object)"3");
        this.assertSerializationCounts(6, 0);
    }

    private void assertSerializationCounts(int serializationCount, int deserializationCount) {
        assert (InvalidatedPojo.invalidSerializationCount == serializationCount) : "Serialization count: expected " + serializationCount + " but was " + InvalidatedPojo.invalidSerializationCount;
        assert (InvalidatedPojo.invalidDeserializationCount == deserializationCount) : "Deserialization count: expected " + deserializationCount + " but was " + InvalidatedPojo.invalidDeserializationCount;
    }

    public static class InvalidatedPojo
    implements Externalizable {
        final Log log = LogFactory.getLog(InvalidatedPojo.class);
        static int invalidSerializationCount;
        static int invalidDeserializationCount;

        public int updateSerializationCount() {
            return ++invalidSerializationCount;
        }

        public int updateDeserializationCount() {
            return ++invalidDeserializationCount;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int serCount = this.updateSerializationCount();
            this.log.trace((Object)("invalidSerializationCount=" + serCount));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int deserCount = this.updateDeserializationCount();
            this.log.trace((Object)("invalidDeserializationCount=" + deserCount));
        }
    }
}

