/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierTxTest")
public class CacheNotifierTxTest
extends AbstractInfinispanTest {
    private Cache<Object, Object> cache;
    private TransactionManager tm;
    private CacheNotifier mockNotifier;
    private CacheNotifier origNotifier;
    private CacheContainer cm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration c = TestCacheManagerFactory.getDefaultConfiguration(true);
        c.fluent().transaction().autoCommit(false);
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cm = TestCacheManagerFactory.createCacheManager(c);
        this.cache = this.cm.getCache();
        this.tm = TestingUtil.getTransactionManager(this.cache);
        this.mockNotifier = (CacheNotifier)EasyMock.createMock(CacheNotifier.class);
        this.origNotifier = TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.mockNotifier, true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.origNotifier, true);
        TestingUtil.killCaches(this.cache);
        this.cm.stop();
    }

    @AfterClass
    public void destroyManager() {
        TestingUtil.killCacheManagers(this.cache.getCacheManager());
    }

    private void initCacheData(Object key, Object value) {
        this.initCacheData(Collections.singletonMap(key, value));
    }

    private void initCacheData(Map<Object, Object> data) {
        this.expectTransactionBoundaries(true);
        this.mockNotifier.notifyCacheEntryCreated(EasyMock.anyObject(), EasyMock.anyBoolean(), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().anyTimes();
        this.mockNotifier.notifyCacheEntryModified(EasyMock.anyObject(), EasyMock.anyObject(), EasyMock.anyBoolean(), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        try {
            this.tm.begin();
            this.cache.putAll(data);
            this.tm.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
        EasyMock.reset((Object[])new Object[]{this.mockNotifier});
    }

    private void expectSingleEntryCreated(Object key, Object value) {
        CacheNotifierTxTest.expectSingleEntryCreated(key, value, this.mockNotifier);
    }

    static void expectSingleEntryCreated(Object key, Object value, CacheNotifier mockNotifier) {
        mockNotifier.notifyCacheEntryCreated(EasyMock.eq((Object)key), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        mockNotifier.notifyCacheEntryCreated(EasyMock.eq((Object)key), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        mockNotifier.notifyCacheEntryModified(EasyMock.eq((Object)key), EasyMock.isNull(), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        mockNotifier.notifyCacheEntryModified(EasyMock.eq((Object)key), EasyMock.eq((Object)value), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
    }

    private void expectTransactionBoundaries(boolean successful) {
        this.mockNotifier.notifyTransactionRegistered((GlobalTransaction)EasyMock.isA(GlobalTransaction.class), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        this.mockNotifier.notifyTransactionCompleted((GlobalTransaction)EasyMock.isA(GlobalTransaction.class), EasyMock.eq((boolean)successful), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
    }

    public void testTxNonexistentRemove() throws Exception {
        this.expectTransactionBoundaries(true);
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.tm.begin();
        this.cache.remove((Object)"doesNotExist");
        this.tm.commit();
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testTxCreationCommit() throws Exception {
        this.expectTransactionBoundaries(true);
        this.expectSingleEntryCreated("key", "value");
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        this.tm.commit();
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testTxCreationRollback() throws Exception {
        this.expectTransactionBoundaries(false);
        this.expectSingleEntryCreated("key", "value");
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        this.tm.rollback();
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testTxOnlyModification() throws Exception {
        this.initCacheData("key", "value");
        this.expectTransactionBoundaries(true);
        this.mockNotifier.notifyCacheEntryModified(EasyMock.eq((Object)"key"), EasyMock.eq((Object)"value"), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        this.mockNotifier.notifyCacheEntryModified(EasyMock.eq((Object)"key"), EasyMock.eq((Object)"value2"), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.tm.begin();
        this.cache.put((Object)"key", (Object)"value2");
        this.tm.commit();
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }

    public void testTxRemoveData() throws Exception {
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.initCacheData(data);
        this.expectTransactionBoundaries(true);
        this.mockNotifier.notifyCacheEntryRemoved(EasyMock.eq((Object)"key2"), EasyMock.eq((Object)"value2"), EasyMock.eq((boolean)true), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        this.mockNotifier.notifyCacheEntryRemoved(EasyMock.eq((Object)"key2"), EasyMock.isNull(), EasyMock.eq((boolean)false), (InvocationContext)EasyMock.isA(InvocationContext.class));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.mockNotifier});
        this.tm.begin();
        this.cache.remove((Object)"key2");
        this.tm.commit();
        EasyMock.verify((Object[])new Object[]{this.mockNotifier});
    }
}

