/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.profiling;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, enabled=false, testName="profiling.AbstractProfileTest")
public abstract class AbstractProfileTest
extends SingleCacheManagerTest {
    protected static final String LOCAL_CACHE_NAME = "local";
    protected static final String REPL_SYNC_CACHE_NAME = "repl_sync";
    protected static final String REPL_ASYNC_CACHE_NAME = "repl_async";
    protected static final String DIST_SYNC_L1_CACHE_NAME = "dist_sync_l1";
    protected static final String DIST_ASYNC_L1_CACHE_NAME = "dist_async_l1";
    protected static final String DIST_SYNC_CACHE_NAME = "dist_sync";
    protected static final String DIST_ASYNC_CACHE_NAME = "dist_async";
    boolean startedInCmdLine = false;
    String clusterNameOverride = null;

    protected void initTest() throws Exception {
        System.out.println("Setting up test params!");
        if (this.startedInCmdLine) {
            this.cacheManager = this.createCacheManager();
        }
    }

    private Configuration getBaseCfg() {
        Configuration cfg = new Configuration();
        cfg.setConcurrencyLevel(5000);
        cfg.setTransactionManagerLookupClass(JBossStandaloneJTAManagerLookup.class.getName());
        return cfg;
    }

    private Configuration getClusteredCfg(Configuration.CacheMode mode, boolean l1) {
        Configuration cfg = this.getBaseCfg();
        cfg.setLockAcquisitionTimeout(60000L);
        cfg.setSyncReplTimeout(60000L);
        cfg.setCacheMode(mode);
        cfg.setFetchInMemoryState(false);
        if (mode.isDistributed()) {
            cfg.setL1CacheEnabled(l1);
            cfg.setL1Lifespan(120000L);
        }
        return cfg;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        gc.setAsyncTransportExecutorFactoryClass(WTE.class.getName());
        this.cacheManager = TestCacheManagerFactory.createCacheManager(gc);
        this.cacheManager.defineConfiguration(LOCAL_CACHE_NAME, this.getBaseCfg());
        this.cacheManager.defineConfiguration(REPL_SYNC_CACHE_NAME, this.getClusteredCfg(Configuration.CacheMode.REPL_SYNC, false));
        this.cacheManager.defineConfiguration(REPL_ASYNC_CACHE_NAME, this.getClusteredCfg(Configuration.CacheMode.REPL_ASYNC, false));
        this.cacheManager.defineConfiguration(DIST_SYNC_CACHE_NAME, this.getClusteredCfg(Configuration.CacheMode.DIST_SYNC, false));
        this.cacheManager.defineConfiguration(DIST_ASYNC_CACHE_NAME, this.getClusteredCfg(Configuration.CacheMode.DIST_ASYNC, false));
        this.cacheManager.defineConfiguration(DIST_SYNC_L1_CACHE_NAME, this.getClusteredCfg(Configuration.CacheMode.DIST_SYNC, true));
        this.cacheManager.defineConfiguration(DIST_ASYNC_L1_CACHE_NAME, this.getClusteredCfg(Configuration.CacheMode.DIST_ASYNC, true));
        return this.cacheManager;
    }

    public static class WTE
    implements ExecutorFactory {
        public ExecutorService getExecutor(Properties p) {
            return new WithinThreadExecutor();
        }
    }
}

