/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.data.Key;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.AsyncAPINonTxSyncReplTest")
public class AsyncAPINonTxSyncReplTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = this.getConfig();
        c.fluent().transaction().autoCommit(false);
        this.createClusteredCaches(2, c);
    }

    protected Configuration getConfig() {
        return AsyncAPINonTxSyncReplTest.getDefaultClusteredConfig(this.sync() ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC, false);
    }

    protected boolean sync() {
        return true;
    }

    public void testAsyncMethods() throws ExecutionException, InterruptedException {
        final Cache c1 = this.cache(0);
        final Cache c2 = this.cache(1);
        String v = "v";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        String v5 = "v5";
        String v6 = "v6";
        String v_null = "v_nonexistent";
        final Key key = new Key("k", true);
        NotifyingFuture f = c1.putAsync((Object)key, (Object)"v");
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key) == null);
        this.log.info((Object)"*** Allowing serialization on key");
        key.allowSerialization();
        this.log.info((Object)"*** Finished allowing serialization on key, checking future if cancelled");
        assert (!f.isCancelled());
        this.log.info((Object)"*** Future not cancelled, checking future.get()");
        assert (f.get() == null);
        assert (f.isDone());
        this.assertOnAllCaches(key, "v", c1, c2);
        f = c1.putAsync((Object)key, (Object)v2);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals("v"));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        this.assertOnAllCaches(key, v2, c1, c2);
        NotifyingFuture f2 = c1.putAllAsync(Collections.singletonMap(key, v3));
        assert (f2 != null);
        assert (!f2.isDone());
        assert (c2.get((Object)key).equals(v2));
        key.allowSerialization();
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        this.assertOnAllCaches(key, v3, c1, c2);
        f = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f != null);
        assert (c2.get((Object)key).equals(v3));
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v3));
        assert (f.isDone());
        this.assertOnAllCaches(key, v3, c1, c2);
        f = c1.removeAsync((Object)key);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals(v3));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (((String)f.get()).equals(v3));
        assert (f.isDone());
        this.assertOnAllCaches(key, null, c1, c2);
        f = c1.putIfAbsentAsync((Object)key, (Object)v4);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key) == null);
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.assertOnAllCaches(key, v4, c1, c2);
        NotifyingFuture f3 = c1.removeAsync((Object)key, (Object)v_null);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        this.assertOnAllCaches(key, v4, c1, c2);
        f3 = c1.removeAsync((Object)key, (Object)v4);
        assert (f3 != null);
        assert (!f3.isDone());
        assert (c2.get((Object)key).equals(v4));
        key.allowSerialization();
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.assertOnAllCaches(key, null, c1, c2);
        f = c1.replaceAsync((Object)key, (Object)v5);
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.assertOnAllCaches(key, null, c1, c2);
        this.log.trace((Object)("Before put(k,v) " + key + ", " + "v"));
        key.allowSerialization();
        this.resetListeners();
        c1.put((Object)key, (Object)"v");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return "v".equals(c1.get((Object)key)) && "v".equals(c2.get((Object)key));
            }
        });
        this.log.trace((Object)("After put(k,v) " + key + ", " + "v"));
        f = c1.replaceAsync((Object)key, (Object)v5);
        assert (f != null);
        assert (!f.isDone());
        assert (c2.get((Object)key).equals("v"));
        key.allowSerialization();
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        this.assertOnAllCaches(key, v5, c1, c2);
        f3 = c1.replaceAsync((Object)key, (Object)v_null, (Object)v6);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        this.assertOnAllCaches(key, v5, c1, c2);
        f3 = c1.replaceAsync((Object)key, (Object)v5, (Object)v6);
        assert (f3 != null);
        assert (!f3.isDone());
        assert (c2.get((Object)key).equals(v5));
        key.allowSerialization();
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.assertOnAllCaches(key, v6, c1, c2);
    }

    protected void assertOnAllCaches(Key k, String v, Cache c1, Cache c2) {
        Object real;
        assert (Util.safeEquals((Object)(real = c1.get((Object)k)), (Object)v)) : "Error on cache 1.  Expected " + v + " and got " + real;
        assert (Util.safeEquals((Object)(real = c2.get((Object)k)), (Object)v)) : "Error on cache 2.  Expected " + v + " and got " + real;
    }

    protected void resetListeners() {
    }
}

