/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.testng.annotations.Test;

@Test(testName="lock.StaleLocksWithCommitDuringStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class StaleLocksWithCommitDuringStateTransferTest
extends MultipleCacheManagersTest {
    public static final int BLOCKING_CACHE_VIEW_ID = 1000;
    Cache<MagicKey, String> c1;
    Cache<MagicKey, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.DIST_SYNC);
        cfg.setLockAcquisitionTimeout(100L);
        cfg.setCacheStopTimeout(100);
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(cfg);
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.c1 = cm1.getCache();
        this.c2 = cm2.getCache();
        this.waitForClusterToForm();
    }

    public void testRollbackLocalFailure() throws Exception {
        this.doTest(false, true);
    }

    public void testCommitLocalFailure() throws Exception {
        this.doTest(true, true);
    }

    public void testRollbackRemoteFailure() throws Exception {
        this.doTest(false, false);
    }

    public void testCommitRemoteFailure() throws Exception {
        this.doTest(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(boolean commit, boolean failOnOriginator) throws Exception {
        MagicKey k1 = new MagicKey(this.c1, "k1");
        MagicKey k2 = new MagicKey(this.c2, "k2");
        this.tm(this.c1).begin();
        this.c1.put((Object)k1, (Object)"v1");
        this.c1.put((Object)k2, (Object)"v2");
        TransactionTable txTable = TestingUtil.extractComponent(this.c1, TransactionTable.class);
        TransactionCoordinator txCoordinator = TestingUtil.extractComponent(this.c1, TransactionCoordinator.class);
        LocalTransaction localTx = txTable.getLocalTransaction(this.tm(this.c1).getTransaction());
        txCoordinator.prepare(localTx);
        final StateTransferLock blockFirst = TestingUtil.extractComponent(failOnOriginator ? this.c1 : this.c2, StateTransferLock.class);
        final StateTransferLock blockSecond = TestingUtil.extractComponent(failOnOriginator ? this.c2 : this.c1, StateTransferLock.class);
        blockFirst.blockNewTransactions(1000);
        Thread worker = new Thread("RehasherSim,StaleLocksWithCommitDuringStateTransferTest"){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    blockSecond.blockNewTransactions(1000);
                    blockFirst.unblockNewTransactions(1000);
                    blockSecond.unblockNewTransactions(1000);
                }
                catch (InterruptedException e) {
                    StaleLocksWithCommitDuringStateTransferTest.this.log.errorf((Throwable)e, "Error blocking/unblocking transactions", new Object[0]);
                }
            }
        };
        worker.start();
        try {
            if (commit) {
                this.tm(this.c1).commit();
            } else {
                this.tm(this.c1).rollback();
            }
            this.tm(this.c1).suspend();
        }
        finally {
            worker.join();
        }
        this.assertNotLocked(this.c1, (Object)k1);
        this.assertNotLocked(this.c2, (Object)k1);
        this.assertNotLocked(this.c1, (Object)k2);
        this.assertNotLocked(this.c2, (Object)k2);
    }
}

