/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplListener {
    Cache<?, ?> c;
    volatile List<Class<? extends VisitableCommand>> expectedCommands;
    List<Class<? extends VisitableCommand>> eagerCommands = new LinkedList<Class<? extends VisitableCommand>>();
    boolean recordCommandsEagerly;
    boolean watchLocal;
    final Lock expectationSetupLock = new ReentrantLock();
    CountDownLatch latch = new CountDownLatch(1);
    volatile boolean sawAtLeastOneInvocation = false;
    boolean expectAny = false;
    private Log log = LogFactory.getLog(ReplListener.class);

    public ReplListener(Cache<?, ?> c) {
        this(c, false);
    }

    public ReplListener(Cache<?, ?> c, boolean recordCommandsEagerly) {
        this(c, recordCommandsEagerly, false);
    }

    public ReplListener(Cache<?, ?> c, boolean recordCommandsEagerly, boolean watchLocal) {
        this.c = c;
        this.recordCommandsEagerly = recordCommandsEagerly;
        this.watchLocal = watchLocal;
        this.c.getAdvancedCache().addInterceptor((CommandInterceptor)new ReplListenerInterceptor(), 1);
    }

    public void expectAny() {
        this.expectAny = true;
        this.expect(new Class[0]);
    }

    public void expectWithTx(Class<? extends VisitableCommand> ... commands) {
        ArrayList<Class<CommitCommand>> cmdsToExpect = new ArrayList<Class<CommitCommand>>();
        cmdsToExpect.add(PrepareCommand.class);
        if (commands != null) {
            cmdsToExpect.addAll(Arrays.asList(commands));
        }
        if (this.c.getConfiguration().getCacheMode().isSynchronous()) {
            cmdsToExpect.add(CommitCommand.class);
        }
        this.expect(cmdsToExpect.toArray(new Class[cmdsToExpect.size()]));
    }

    public void expectAnyWithTx() {
        ArrayList<Class> cmdsToExpect = new ArrayList<Class>(2);
        cmdsToExpect.add(PrepareCommand.class);
        if (this.c.getConfiguration().getCacheMode().isSynchronous()) {
            cmdsToExpect.add(CommitCommand.class);
        }
        this.expect(cmdsToExpect.toArray(new Class[cmdsToExpect.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expect(Class<? extends VisitableCommand> ... expectedCommands) {
        this.expectationSetupLock.lock();
        try {
            if (this.expectedCommands == null) {
                this.expectedCommands = new CopyOnWriteArrayList<Class<? extends VisitableCommand>>();
            }
            this.expectedCommands.addAll(Arrays.asList(expectedCommands));
            this.info("Setting expected commands to " + this.expectedCommands);
            this.info("Record eagerly is " + this.recordCommandsEagerly + ", and eager commands are " + this.eagerCommands);
            if (this.recordCommandsEagerly) {
                this.expectedCommands.removeAll(this.eagerCommands);
                if (!this.eagerCommands.isEmpty()) {
                    this.sawAtLeastOneInvocation = true;
                }
                this.eagerCommands.clear();
            }
        }
        finally {
            this.expectationSetupLock.unlock();
        }
    }

    private void info(String str) {
        this.log.info((Object)(" [" + this.c + "] " + str));
    }

    public void waitForRpc() {
        this.waitForRpc(30L, TimeUnit.SECONDS);
    }

    public void waitForRpc(long time, TimeUnit unit) {
        assert (this.expectedCommands != null) : "there are no replication expectations; please use ReplListener.expect() before calling this method";
        try {
            boolean successful = this.expectAny && this.sawAtLeastOneInvocation || !this.expectAny && this.expectedCommands.isEmpty();
            this.info("Expect Any is " + this.expectAny + ", saw at least one? " + this.sawAtLeastOneInvocation + " Successful? " + successful + " Expected commands " + this.expectedCommands);
            if (!successful && !this.latch.await(time, unit)) {
                EmbeddedCacheManager cacheManager = this.c.getCacheManager();
                assert (false) : "Waiting for more than " + time + " " + (Object)((Object)unit) + " and following commands did not replicate: " + this.expectedCommands + " on cache [" + cacheManager.getAddress() + "]";
            } else {
                this.info("Exiting wait for rpc with expected commands " + this.expectedCommands);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected", e);
        }
        finally {
            this.expectationSetupLock.lock();
            this.expectedCommands = null;
            this.expectationSetupLock.unlock();
            this.expectAny = false;
            this.sawAtLeastOneInvocation = false;
            this.latch = new CountDownLatch(1);
            this.eagerCommands.clear();
        }
    }

    public Cache<?, ?> getCache() {
        return this.c;
    }

    public void resetEager() {
        this.eagerCommands.clear();
    }

    public void reconfigureListener(boolean recordCommandsEagerly, boolean watchLocal) {
        this.recordCommandsEagerly = recordCommandsEagerly;
        this.watchLocal = watchLocal;
    }

    protected class ReplListenerInterceptor
    extends CommandInterceptor {
        protected ReplListenerInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
            Object o;
            try {
                o = this.invokeNextInterceptor(ctx, cmd);
            }
            finally {
                ReplListener.this.info("Checking whether command " + cmd.getClass().getSimpleName() + " should be marked as local with watch local set to " + ReplListener.this.watchLocal);
                if (!ctx.isOriginLocal() || ReplListener.this.watchLocal) {
                    this.markAsVisited(cmd);
                }
            }
            return o;
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand cmd) throws Throwable {
            Object o = this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)cmd);
            if (!ctx.isOriginLocal() || ReplListener.this.watchLocal) {
                this.markAsVisited((VisitableCommand)cmd);
                for (WriteCommand mod : cmd.getModifications()) {
                    this.markAsVisited((VisitableCommand)mod);
                }
            }
            return o;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markAsVisited(VisitableCommand cmd) {
            ReplListener.this.expectationSetupLock.lock();
            try {
                ReplListener.this.info("ReplListener saw command " + cmd);
                if (ReplListener.this.expectedCommands != null) {
                    if (ReplListener.this.expectedCommands.remove(cmd.getClass())) {
                        ReplListener.this.info("Successfully removed command: " + cmd.getClass());
                    } else if (ReplListener.this.recordCommandsEagerly) {
                        ReplListener.this.eagerCommands.add(cmd.getClass());
                    }
                    ReplListener.this.sawAtLeastOneInvocation = true;
                    if (ReplListener.this.expectedCommands.isEmpty()) {
                        ReplListener.this.info("Nothing to wait for, releasing latch");
                        ReplListener.this.latch.countDown();
                    }
                } else if (ReplListener.this.recordCommandsEagerly) {
                    ReplListener.this.eagerCommands.add(cmd.getClass());
                }
            }
            finally {
                ReplListener.this.expectationSetupLock.unlock();
            }
        }
    }
}

