/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;
import org.infinispan.util.concurrent.ReclosableLatch;

public class Key
implements Externalizable {
    String value;
    final ReclosableLatch latch = new ReclosableLatch(false);
    final boolean lockable;
    private static final long serialVersionUID = 4745232904453872125L;

    public Key() {
        this.lockable = false;
    }

    public Key(String value, boolean lockable) {
        this.value = value;
        this.lockable = lockable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key k1 = (Key)o;
        return !(this.value != null ? !this.value.equals(k1.value) : k1.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.value);
        if (this.lockable) {
            try {
                if (!this.latch.await(5L, TimeUnit.MINUTES)) {
                    throw new RuntimeException("Cannot serialize!!");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.latch.close();
        }
    }

    public void allowSerialization() {
        if (this.lockable) {
            this.latch.open();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = (String)in.readObject();
    }
}

