/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.federation.FederatedDocumentChanges;
import org.modeshape.jcr.federation.FederatedDocumentReader;
import org.modeshape.jcr.federation.FederatedDocumentWriter;
import org.modeshape.jcr.federation.FederatedSchematicEntry;
import org.modeshape.jcr.federation.spi.Connector;
import org.modeshape.jcr.federation.spi.ConnectorException;
import org.modeshape.jcr.federation.spi.DocumentChanges;
import org.modeshape.jcr.federation.spi.PageKey;
import org.modeshape.jcr.federation.spi.Pageable;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.StringReference;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;

public class FederatedDocumentStore
implements DocumentStore {
    private static final Logger LOGGER = Logger.getLogger(FederatedDocumentStore.class);
    private static final String FEDERATED_WORKSPACE_KEY = NodeKey.keyForWorkspaceName("federated_ws");
    private final LocalDocumentStore localDocumentStore;
    private final Connectors connectors;
    private DocumentTranslator translator;
    private String localSourceKey;

    public FederatedDocumentStore(Connectors connectors, SchematicDb localDb) {
        this.connectors = connectors;
        this.localDocumentStore = new LocalDocumentStore(localDb);
    }

    protected final DocumentTranslator translator() {
        if (this.translator == null) {
            this.translator = this.connectors.getDocumentTranslator();
        }
        return this.translator;
    }

    @Override
    public LocalDocumentStore localStore() {
        return this.localDocumentStore;
    }

    @Override
    public String newDocumentKey(String parentKey, Name documentName) {
        String parentDocumentId;
        String newChildId;
        if (this.isLocalSource(parentKey)) {
            return this.localStore().newDocumentKey(parentKey, documentName);
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(parentKey));
        if (connector != null && !StringUtil.isBlank((String)(newChildId = connector.newDocumentId(parentDocumentId = this.documentIdFromNodeKey(parentKey), documentName)))) {
            return this.documentIdToNodeKey(connector.getSourceName(), newChildId).toString();
        }
        return null;
    }

    @Override
    public SchematicEntry storeDocument(String key, Document document) {
        if (this.isLocalSource(key)) {
            return this.localStore().putIfAbsent(key, document);
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(key));
        if (connector != null) {
            EditableDocument editableDocument = this.replaceNodeKeysWithDocumentIds(document);
            connector.storeDocument((Document)editableDocument);
        }
        return null;
    }

    @Override
    public void updateDocument(String key, Document document, SessionNode sessionNode) {
        if (this.isLocalSource(key)) {
            this.localStore().updateDocument(key, document, null);
        } else {
            Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(key));
            if (connector != null) {
                EditableDocument editableDocument = this.replaceNodeKeysWithDocumentIds(document);
                String documentId = this.documentIdFromNodeKey(key);
                SessionNode.NodeChanges nodeChanges = sessionNode.getNodeChanges();
                DocumentChanges documentChanges = this.createDocumentChanges(nodeChanges, connector.getSourceName(), editableDocument, documentId);
                connector.updateDocument(documentChanges);
            }
        }
    }

    private DocumentChanges createDocumentChanges(SessionNode.NodeChanges nodeChanges, String sourceName, EditableDocument editableDocument, String documentId) {
        FederatedDocumentChanges documentChanges = new FederatedDocumentChanges(documentId, (Document)editableDocument);
        documentChanges.setPropertyChanges(nodeChanges.changedPropertyNames(), nodeChanges.removedPropertyNames());
        documentChanges.setMixinChanges(nodeChanges.addedMixins(), nodeChanges.removedMixins());
        LinkedHashMap<NodeKey, Name> appendedChildren = nodeChanges.appendedChildren();
        this.validateSameSourceForAllNodes(sourceName, appendedChildren.keySet());
        Map<NodeKey, LinkedHashMap<NodeKey, Name>> childrenInsertedBefore = nodeChanges.childrenInsertedBefore();
        this.validateSameSourceForAllNodes(sourceName, childrenInsertedBefore.keySet());
        HashMap<String, LinkedHashMap<String, Name>> processedChildrenInsertions = new HashMap<String, LinkedHashMap<String, Name>>(childrenInsertedBefore.size());
        for (NodeKey childKey : childrenInsertedBefore.keySet()) {
            LinkedHashMap<NodeKey, Name> insertions = childrenInsertedBefore.get(childKey);
            this.validateSameSourceForAllNodes(sourceName, insertions.keySet());
            processedChildrenInsertions.put(this.documentIdFromNodeKey(childKey), this.nodeKeyMapToIdentifierMap(insertions));
        }
        documentChanges.setChildrenChanges(this.nodeKeyMapToIdentifierMap(appendedChildren), this.nodeKeyMapToIdentifierMap(nodeChanges.renamedChildren()), this.nodeKeySetToIdentifiersSet(nodeChanges.removedChildren()), processedChildrenInsertions);
        Set<NodeKey> addedParents = nodeChanges.addedParents();
        this.validateSameSourceForAllNodes(sourceName, addedParents);
        this.validateNodeKeyHasSource(sourceName, nodeChanges.newPrimaryParent());
        documentChanges.setParentChanges(this.nodeKeySetToIdentifiersSet(addedParents), this.nodeKeySetToIdentifiersSet(nodeChanges.removedParents()), this.documentIdFromNodeKey(nodeChanges.newPrimaryParent()));
        Set<NodeKey> addedWeakReferrers = nodeChanges.addedWeakReferrers();
        this.validateSameSourceForAllNodes(sourceName, addedWeakReferrers);
        Set<NodeKey> addedStrongReferrers = nodeChanges.addedStrongReferrers();
        this.validateSameSourceForAllNodes(sourceName, addedStrongReferrers);
        documentChanges.setReferrerChanges(this.nodeKeySetToIdentifiersSet(addedWeakReferrers), this.nodeKeySetToIdentifiersSet(nodeChanges.removedWeakReferrers()), this.nodeKeySetToIdentifiersSet(addedStrongReferrers), this.nodeKeySetToIdentifiersSet(nodeChanges.removedStrongReferrers()));
        return documentChanges;
    }

    private void validateSameSourceForAllNodes(String sourceName, Collection<NodeKey> nodeKeys) {
        for (NodeKey nodeKey : nodeKeys) {
            this.validateNodeKeyHasSource(sourceName, nodeKey);
        }
    }

    private void validateNodeKeyHasSource(String sourceName, NodeKey nodeKey) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        if (nodeKey != null && !sourceKey.equals(nodeKey.getSourceKey())) {
            throw new ConnectorException(JcrI18n.federationNodeKeyDoesNotBelongToSource, nodeKey, sourceName);
        }
    }

    private <T> Map<String, T> nodeKeyMapToIdentifierMap(Map<NodeKey, T> nodeKeysMap) {
        HashMap<String, T> result = new HashMap<String, T>(nodeKeysMap.size());
        for (NodeKey key : nodeKeysMap.keySet()) {
            result.put(this.documentIdFromNodeKey(key), nodeKeysMap.get(key));
        }
        return result;
    }

    private <T> LinkedHashMap<String, T> nodeKeyMapToIdentifierMap(LinkedHashMap<NodeKey, T> nodeKeysMap) {
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(nodeKeysMap.size());
        for (NodeKey key : nodeKeysMap.keySet()) {
            result.put(this.documentIdFromNodeKey(key), nodeKeysMap.get(key));
        }
        return result;
    }

    private Set<String> nodeKeySetToIdentifiersSet(Set<NodeKey> nodeKeysSet) {
        HashSet<String> result = new HashSet<String>(nodeKeysSet.size());
        for (NodeKey key : nodeKeysSet) {
            result.add(this.documentIdFromNodeKey(key));
        }
        return result;
    }

    @Override
    public SchematicEntry get(String key) {
        String docId;
        Document document;
        if (this.isLocalSource(key)) {
            return this.localStore().get(key);
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(key));
        if (connector != null && (document = connector.getDocumentById(docId = this.documentIdFromNodeKey(key))) != null) {
            EditableDocument editableDocument = this.replaceConnectorIdsWithNodeKeys(document, connector.getSourceName());
            editableDocument = this.updateCachingTtl(connector, editableDocument);
            Object removedContainer = (editableDocument = this.updateQueryable(connector, editableDocument)).remove("embeddedDocuments");
            if (removedContainer instanceof EditableDocument) {
                EditableDocument embeddedDocs = (EditableDocument)removedContainer;
                for (Document.Field field : embeddedDocs.fields()) {
                    String id = field.getName();
                    Document doc = field.getValueAsDocument();
                    if (doc == null) continue;
                    this.localStore().put(id, doc);
                }
            }
            return new FederatedSchematicEntry(editableDocument);
        }
        return null;
    }

    private EditableDocument updateCachingTtl(Connector connector, EditableDocument editableDocument) {
        FederatedDocumentReader reader = new FederatedDocumentReader(this.translator(), (Document)editableDocument);
        if (reader.getCacheTtlSeconds() == null && connector.getCacheTtlSeconds() != null) {
            FederatedDocumentWriter writer = new FederatedDocumentWriter(null, (Document)editableDocument);
            writer.setCacheTtlSeconds(connector.getCacheTtlSeconds());
            return writer.document();
        }
        return editableDocument;
    }

    private EditableDocument updateQueryable(Connector connector, EditableDocument editableDocument) {
        if (!connector.isQueryable().booleanValue()) {
            this.translator.setQueryable(editableDocument, false);
            return editableDocument;
        }
        return editableDocument;
    }

    @Override
    public boolean containsKey(String key) {
        if (this.isLocalSource(key)) {
            return this.localStore().containsKey(key);
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(key));
        return connector != null && connector.hasDocument(this.documentIdFromNodeKey(key));
    }

    @Override
    public boolean remove(String key) {
        if (this.isLocalSource(key)) {
            boolean result = this.localStore().remove(key);
            this.connectors.internalNodeRemoved(key);
            return result;
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(key));
        if (connector != null) {
            boolean result = connector.removeDocument(this.documentIdFromNodeKey(key));
            this.connectors.externalNodeRemoved(key);
            return result;
        }
        return false;
    }

    @Override
    public boolean updatesRequirePreparing() {
        return this.localDocumentStore.updatesRequirePreparing();
    }

    @Override
    public boolean prepareDocumentsForUpdate(Collection<String> keys) {
        return this.localDocumentStore.prepareDocumentsForUpdate(keys);
    }

    @Override
    public TransactionManager transactionManager() {
        return this.localStore().transactionManager();
    }

    @Override
    public XAResource xaResource() {
        return this.localStore().xaResource();
    }

    @Override
    public void setLocalSourceKey(String localSourceKey) {
        this.localSourceKey = localSourceKey;
    }

    @Override
    public String getLocalSourceKey() {
        return this.localSourceKey;
    }

    @Override
    public String createExternalProjection(String projectedNodeKey, String sourceName, String externalPath, String alias) {
        String externalNodeId;
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        Connector connector = this.connectors.getConnectorForSourceKey(sourceKey);
        if (connector != null && (externalNodeId = connector.getDocumentId(externalPath)) != null) {
            String externalNodeKey = this.documentIdToNodeKeyString(sourceName, externalNodeId);
            this.connectors.addProjection(externalNodeKey, projectedNodeKey, alias);
            return externalNodeKey;
        }
        return null;
    }

    @Override
    public Document getChildrenBlock(String key) {
        PageKey blockKey;
        Document childrenBlock;
        if (this.isLocalSource(key)) {
            return this.localStore().getChildrenBlock(key);
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(key));
        if (connector != null && connector instanceof Pageable && (childrenBlock = ((Pageable)((Object)connector)).getChildren(blockKey = new PageKey(key = this.documentIdFromNodeKey(key)))) != null) {
            return this.replaceConnectorIdsWithNodeKeys(childrenBlock, connector.getSourceName());
        }
        return null;
    }

    @Override
    public Document getChildReference(String parentKey, String childKey) {
        if (this.isLocalSource(parentKey)) {
            return this.localStore().getChildReference(parentKey, childKey);
        }
        Connector connector = this.connectors.getConnectorForSourceKey(this.sourceKey(parentKey));
        if (connector != null) {
            Document doc = connector.getChildReference(parentKey = this.documentIdFromNodeKey(parentKey), childKey = this.documentIdFromNodeKey(childKey));
            if (doc != null) {
                String key = doc.getString("key");
                key = this.documentIdToNodeKeyString(connector.getSourceName(), key);
                doc = doc.with("key", (Object)key);
            }
            return doc;
        }
        return null;
    }

    @Override
    public ExternalBinaryValue getExternalBinary(String sourceName, String id) {
        Connector connector = this.connectors.getConnectorForSourceName(sourceName);
        if (connector == null) {
            LOGGER.debug("Connector not found for source name {0} while trying to get a binary value", new Object[]{sourceName});
            return null;
        }
        return connector.getBinaryValue(id);
    }

    private boolean isLocalSource(String key) {
        return !NodeKey.isValidFormat(key) || StringUtil.isBlank((String)this.localSourceKey) || key.startsWith(this.localSourceKey);
    }

    private String sourceKey(String nodeKey) {
        return NodeKey.sourceKey(nodeKey);
    }

    private String documentIdToNodeKeyString(String sourceName, String documentId) {
        return this.documentIdToNodeKey(sourceName, documentId).toString();
    }

    private NodeKey documentIdToNodeKey(String sourceName, String documentId) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        return new NodeKey(sourceKey, FEDERATED_WORKSPACE_KEY, documentId);
    }

    private String documentIdFromNodeKey(String nodeKey) {
        return new NodeKey(nodeKey).getIdentifier();
    }

    private String documentIdFromNodeKey(NodeKey nodeKey) {
        return nodeKey != null ? nodeKey.getIdentifier() : null;
    }

    private EditableDocument replaceConnectorIdsWithNodeKeys(Document externalDocument, String sourceName) {
        String projectedNodeKey;
        FederatedDocumentReader reader = new FederatedDocumentReader(this.translator(), externalDocument);
        FederatedDocumentWriter writer = new FederatedDocumentWriter(this.translator(), externalDocument);
        String externalDocumentId = reader.getDocumentId();
        String externalDocumentKey = null;
        if (!StringUtil.isBlank((String)externalDocumentId)) {
            externalDocumentKey = this.documentIdToNodeKeyString(sourceName, externalDocumentId);
            writer.setId(externalDocumentKey);
        }
        ArrayList<String> parentKeys = new ArrayList<String>();
        for (String parentId : reader.getParentIds()) {
            String parentKey = this.documentIdToNodeKeyString(sourceName, parentId);
            parentKeys.add(parentKey);
        }
        EditableDocument childrenInfo = writer.document().getDocument("childrenInfo");
        if (childrenInfo != null) {
            String lastBlockKey;
            String nextBlockKey = childrenInfo.getString("nextBlock");
            if (!StringUtil.isBlank((String)nextBlockKey)) {
                childrenInfo.setString("nextBlock", this.documentIdToNodeKeyString(sourceName, nextBlockKey));
            }
            if (!StringUtil.isBlank((String)(lastBlockKey = childrenInfo.getString("lastBlock")))) {
                childrenInfo.setString("lastBlock", this.documentIdToNodeKeyString(sourceName, lastBlockKey));
            }
        }
        if (externalDocumentKey != null && !StringUtil.isBlank((String)(projectedNodeKey = this.connectors.getProjectedNodeKey(externalDocumentKey)))) {
            parentKeys.add(projectedNodeKey);
        }
        writer.setParents(parentKeys);
        ArrayList<EditableDocument> updatedChildren = new ArrayList<EditableDocument>();
        for (Document document : reader.getChildren()) {
            EditableDocument childWithReplacedIds = this.replaceConnectorIdsWithNodeKeys(document, sourceName);
            updatedChildren.add(childWithReplacedIds);
        }
        writer.setChildren(updatedChildren);
        for (Property property : reader.getProperties().values()) {
            if (property.isEmpty() || !property.isReference()) continue;
            if (property.isSingle()) {
                Object value = this.convertReferenceValue(property.getFirstValue(), sourceName);
                writer.addProperty(property.getName(), value);
                continue;
            }
            assert (property.isMultiple());
            Object[] values = property.getValuesAsArray();
            for (int i = 0; i != values.length; ++i) {
                values[i] = this.convertReferenceValue(values[i], sourceName);
            }
            writer.addProperty(property.getName(), values);
        }
        return writer.document();
    }

    private Object convertReferenceValue(Object value, String sourceName) {
        if (value instanceof NodeKeyReference) {
            NodeKeyReference ref = (NodeKeyReference)value;
            NodeKey key = ref.getNodeKey();
            NodeKey converted = this.documentIdToNodeKey(sourceName, key.toString());
            boolean foreign = !converted.getSourceKey().equals(this.localSourceKey);
            ReferenceFactory factory = ref.isWeak() ? this.translator.getReferenceFactory() : this.translator.getReferenceFactory();
            return factory.create(converted, foreign);
        }
        if (value instanceof StringReference) {
            StringReference ref = (StringReference)value;
            NodeKey converted = this.documentIdToNodeKey(sourceName, ref.toString());
            boolean foreign = !converted.getSourceKey().equals(this.localSourceKey);
            ReferenceFactory factory = ref.isWeak() ? this.translator.getReferenceFactory() : this.translator.getReferenceFactory();
            return factory.create(converted, foreign);
        }
        return value;
    }

    private EditableDocument replaceNodeKeysWithDocumentIds(Document document) {
        FederatedDocumentReader reader = new FederatedDocumentReader(this.translator(), document);
        FederatedDocumentWriter writer = new FederatedDocumentWriter(this.translator(), document);
        String documentNodeKey = reader.getDocumentId();
        assert (documentNodeKey != null);
        String externalDocumentId = this.documentIdFromNodeKey(documentNodeKey);
        writer.setId(externalDocumentId);
        List<String> parentKeys = reader.getParentIds();
        String projectedNodeKey = this.connectors.getProjectedNodeKey(documentNodeKey);
        if (!StringUtil.isBlank((String)projectedNodeKey)) {
            parentKeys.remove(projectedNodeKey);
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        for (String parentKey : parentKeys) {
            String string = this.documentIdFromNodeKey(parentKey);
            parentIds.add(string);
        }
        writer.setParents(parentIds);
        ArrayList<EditableDocument> updatedChildren = new ArrayList<EditableDocument>();
        for (Document document2 : reader.getChildren()) {
            EditableDocument childWithReplacedIds = this.replaceNodeKeysWithDocumentIds(document2);
            updatedChildren.add(childWithReplacedIds);
        }
        writer.setChildren(updatedChildren);
        return writer.document();
    }
}

