/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DeterminableMethod;

public class DoOptions
extends DeterminableMethod {
    private static Logger LOG = Logger.getLogger(DoOptions.class);
    private IWebdavStore store;
    private ResourceLocks resourceLocks;

    public DoOptions(IWebdavStore store, ResourceLocks resLocks) {
        this.store = store;
        this.resourceLocks = resLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName(), new Object[0]);
        String tempLockOwner = "doOptions" + System.currentTimeMillis() + req.toString();
        String path = this.getRelativePath(req);
        if (this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
            StoredObject so = null;
            try {
                resp.addHeader("DAV", "1, 2");
                so = this.store.getStoredObject(transaction, path);
                String methodsAllowed = DoOptions.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.addHeader("MS-Author-Via", "DAV");
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                resp.sendError(500);
            }
            finally {
                this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        } else {
            resp.sendError(500);
        }
    }
}

