/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.model.RestItem;

public final class RestProperty
extends RestItem {
    private final List<String> values;

    public RestProperty(String name, String url, String parentUrl, List<String> values) {
        super(name, url, parentUrl);
        this.values = values != null ? values : Collections.emptyList();
    }

    List<String> getValues() {
        return this.values;
    }

    String getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    boolean isMultiValue() {
        return this.values.size() > 1;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject object = new JSONObject();
        if (this.isMultiValue()) {
            object.put("values", this.values);
        } else if (this.getValue() != null) {
            object.put(this.name, (Object)this.getValue());
        }
        object.put("self", (Object)this.url);
        object.put("up", (Object)this.parentUrl);
        return object;
    }
}

