/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.output;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.spi.WriterException;
import org.jboss.resteasy.util.Types;
import org.modeshape.web.jcr.rest.model.JSONAble;

@Provider
@Produces(value={"application/json"})
public class JSONBodyWriter
implements MessageBodyWriter<Object> {
    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            if (this.isJSONAble(type)) {
                return this.getString((JSONAble)object).getBytes().length;
            }
            if (this.isJSONAbleCollection(type, genericType)) {
                return this.getString((Collection)object).getBytes().length;
            }
            return 0L;
        }
        catch (JSONException e) {
            throw new WriterException((Throwable)e);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isJSONAble(type) || this.isJSONAbleCollection(type, genericType);
    }

    private boolean isJSONAble(Class<?> type) {
        return JSONAble.class.isAssignableFrom(type);
    }

    private boolean isJSONAbleCollection(Class<?> type, Type genericType) {
        if ((Collection.class.isAssignableFrom(type) || type.isArray()) && genericType != null) {
            Class baseType = Types.getCollectionBaseType(type, (Type)genericType);
            return baseType != null && JSONAble.class.isAssignableFrom(baseType);
        }
        return false;
    }

    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        String content;
        block4: {
            try {
                if (this.isJSONAble(type)) {
                    content = this.getString((JSONAble)object);
                    break block4;
                }
                if (this.isJSONAbleCollection(type, genericType)) {
                    content = this.getString((Collection)object);
                    break block4;
                }
                return;
            }
            catch (JSONException e) {
                throw new WriterException((Throwable)e);
            }
        }
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(entityStream));
        printWriter.write(content);
        printWriter.flush();
    }

    protected String getString(JSONAble jsonAble) throws JSONException {
        return jsonAble.toJSON().toString();
    }

    protected String getString(JSONArray array) throws JSONException {
        return array.toString();
    }

    private String getString(Collection<JSONAble> collection) throws JSONException {
        return this.getString(this.toArray(collection));
    }

    private JSONArray toArray(Collection<JSONAble> collection) throws JSONException {
        JSONArray array = new JSONArray();
        for (JSONAble jsonAble : collection) {
            array.put((Object)jsonAble.toJSON());
        }
        return array;
    }
}

