/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.api.Binary;
import org.modeshape.web.jcr.webdav.ContentMapper;

public class DefaultContentMapper
implements ContentMapper {
    public static final String INIT_CONTENT_PRIMARY_TYPE_NAMES = "org.modeshape.web.jcr.webdav.CONTENT_PRIMARY_TYPE_NAMES";
    public static final String INIT_RESOURCE_PRIMARY_TYPES_NAMES = "org.modeshape.web.jcr.webdav.RESOURCE_PRIMARY_TYPE_NAMES";
    public static final String INIT_NEW_FOLDER_PRIMARY_TYPE_NAME = "org.modeshape.web.jcr.webdav.NEW_FOLDER_PRIMARY_TYPE_NAME";
    public static final String INIT_NEW_RESOURCE_PRIMARY_TYPE_NAME = "org.modeshape.web.jcr.webdav.NEW_RESOURCE_PRIMARY_TYPE_NAME";
    public static final String INIT_NEW_CONTENT_PRIMARY_TYPE_NAME = "org.modeshape.web.jcr.webdav.NEW_CONTENT_PRIMARY_TYPE_NAME";
    private static final String CONTENT_NODE_NAME = "jcr:content";
    private static final String DATA_PROP_NAME = "jcr:data";
    private static final String MODIFIED_PROP_NAME = "jcr:lastModified";
    private static final String ENCODING_PROP_NAME = "jcr:encoding";
    private static final String MIME_TYPE_PROP_NAME = "jcr:mimeType";
    private static final String DEFAULT_CONTENT_PRIMARY_TYPES = "nt:resource, mode:resource";
    private static final String DEFAULT_RESOURCE_PRIMARY_TYPES = "nt:file";
    private static final String DEFAULT_NEW_FOLDER_PRIMARY_TYPE = "nt:folder";
    private static final String DEFAULT_NEW_RESOURCE_PRIMARY_TYPE = "nt:file";
    private static final String DEFAULT_NEW_CONTENT_PRIMARY_TYPE = "nt:resource";
    private Collection<String> contentPrimaryTypes;
    private Collection<String> filePrimaryTypes;
    private String newFolderPrimaryType;
    private String newResourcePrimaryType;
    private String newContentPrimaryType;
    private final Logger logger = Logger.getLogger(this.getClass());

    @Override
    public void initialize(ServletContext servletContext) {
        String contentPrimaryTypes = this.getParam(servletContext, INIT_CONTENT_PRIMARY_TYPE_NAMES);
        String resourcePrimaryTypes = this.getParam(servletContext, INIT_RESOURCE_PRIMARY_TYPES_NAMES);
        String newFolderPrimaryType = this.getParam(servletContext, INIT_NEW_FOLDER_PRIMARY_TYPE_NAME);
        String newResourcePrimaryType = this.getParam(servletContext, INIT_NEW_RESOURCE_PRIMARY_TYPE_NAME);
        String newContentPrimaryType = this.getParam(servletContext, INIT_NEW_CONTENT_PRIMARY_TYPE_NAME);
        this.logger.debug("DefaultContentMapper initial content primary types = " + contentPrimaryTypes, new Object[0]);
        this.logger.debug("DefaultContentMapper initial file primary types = " + this.filePrimaryTypes, new Object[0]);
        this.logger.debug("DefaultContentMapper initial new folder primary types = " + newFolderPrimaryType, new Object[0]);
        this.logger.debug("DefaultContentMapper initial new resource primary types = " + newResourcePrimaryType, new Object[0]);
        this.logger.debug("DefaultContentMapper initial new content primary types = " + newContentPrimaryType, new Object[0]);
        this.contentPrimaryTypes = DefaultContentMapper.split(contentPrimaryTypes != null ? contentPrimaryTypes : DEFAULT_CONTENT_PRIMARY_TYPES);
        this.filePrimaryTypes = DefaultContentMapper.split(resourcePrimaryTypes != null ? resourcePrimaryTypes : "nt:file");
        this.newFolderPrimaryType = newFolderPrimaryType != null ? newFolderPrimaryType : DEFAULT_NEW_FOLDER_PRIMARY_TYPE;
        this.newResourcePrimaryType = newResourcePrimaryType != null ? newResourcePrimaryType : "nt:file";
        this.newContentPrimaryType = newContentPrimaryType != null ? newContentPrimaryType : DEFAULT_NEW_CONTENT_PRIMARY_TYPE;
    }

    protected String getParam(ServletContext servletContext, String name) {
        return servletContext.getInitParameter(name);
    }

    private static Set<String> setFor(String ... elements) {
        HashSet<String> set = new HashSet<String>(elements.length);
        set.addAll(Arrays.asList(elements));
        return set;
    }

    private static Set<String> split(String commaDelimitedString) {
        return DefaultContentMapper.setFor(commaDelimitedString.split("\\s*,\\s*"));
    }

    @Override
    public InputStream getResourceContent(Node node) throws RepositoryException {
        if (!node.hasNode(CONTENT_NODE_NAME)) {
            return null;
        }
        return node.getProperty("jcr:content/jcr:data").getBinary().getStream();
    }

    @Override
    public long getResourceLength(Node node) throws RepositoryException {
        if (!node.hasNode(CONTENT_NODE_NAME)) {
            return -1L;
        }
        return node.getProperty("jcr:content/jcr:data").getLength();
    }

    @Override
    public Date getLastModified(Node node) throws RepositoryException {
        if (!node.hasNode(CONTENT_NODE_NAME)) {
            return null;
        }
        return node.getProperty("jcr:content/jcr:lastModified").getDate().getTime();
    }

    @Override
    public boolean isFolder(Node node) throws RepositoryException {
        return !this.isFile(node) && !this.isContent(node);
    }

    @Override
    public boolean isFile(Node node) throws RepositoryException {
        for (String nodeType : this.filePrimaryTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isContent(Node node) throws RepositoryException {
        for (String nodeType : this.contentPrimaryTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createFile(Node parentNode, String fileName) throws RepositoryException {
        Node resourceNode = parentNode.addNode(fileName, this.newResourcePrimaryType);
        Node contentNode = resourceNode.addNode(CONTENT_NODE_NAME, this.newContentPrimaryType);
        contentNode.setProperty(DATA_PROP_NAME, "");
        contentNode.setProperty(MODIFIED_PROP_NAME, Calendar.getInstance());
        contentNode.setProperty(ENCODING_PROP_NAME, "UTF-8");
        contentNode.setProperty(MIME_TYPE_PROP_NAME, "text/plain");
    }

    @Override
    public void createFolder(Node parentNode, String folderName) throws RepositoryException {
        parentNode.addNode(folderName, this.newFolderPrimaryType);
    }

    @Override
    public long setContent(Node parentNode, String resourceName, InputStream newContent, String contentType, String characterEncoding) throws RepositoryException, IOException {
        Node contentNode = parentNode.hasNode(CONTENT_NODE_NAME) ? parentNode.getNode(CONTENT_NODE_NAME) : parentNode.addNode(CONTENT_NODE_NAME, this.newContentPrimaryType);
        contentNode.setProperty(ENCODING_PROP_NAME, characterEncoding != null ? characterEncoding : "UTF-8");
        Binary binary = (Binary)parentNode.getSession().getValueFactory().createBinary(newContent);
        contentNode.setProperty(DATA_PROP_NAME, (javax.jcr.Binary)binary);
        contentNode.setProperty(MODIFIED_PROP_NAME, Calendar.getInstance());
        if (contentType == null) {
            contentType = binary.getMimeType(resourceName);
        }
        contentNode.setProperty(MIME_TYPE_PROP_NAME, contentType);
        return contentNode.getProperty(DATA_PROP_NAME).getLength();
    }
}

