/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.web.jcr.webdav.RequestResolver;
import org.modeshape.web.jcr.webdav.ResolvedRequest;

public class MultiRepositoryRequestResolver
implements RequestResolver {
    protected static final String PATH_PATTERN_STRING = "/*(([^/]*)(/+([^/]*)?(/+(.*))?)?)?";
    protected static final Pattern PATH_PATTERN = Pattern.compile("/*(([^/]*)(/+([^/]*)?(/+(.*))?)?)?");
    protected static final int REPOSITORY_NAME_GROUP = 2;
    protected static final int WORKSPACE_WITH_SLASH_GROUP = 3;
    protected static final int WORKSPACE_NAME_GROUP = 4;
    protected static final int PATH_GROUP = 5;
    protected static final String ROOT_NODE_PATH = "/";

    @Override
    public void initialize(ServletContext context) {
    }

    @Override
    public ResolvedRequest resolve(HttpServletRequest request, String relativePath) {
        Matcher matcher;
        if (relativePath != null && relativePath.length() != 0 && (matcher = PATH_PATTERN.matcher(relativePath)).matches()) {
            String repositoryName = matcher.group(2);
            String workspaceName = matcher.group(4);
            String nodePath = matcher.group(5);
            if (nodePath == null) {
                if (workspaceName != null) {
                    if (workspaceName.length() == 0 && ROOT_NODE_PATH.equals(matcher.group(3))) {
                        workspaceName = null;
                    } else {
                        nodePath = ROOT_NODE_PATH;
                    }
                } else if (repositoryName != null && repositoryName.length() == 0) {
                    repositoryName = null;
                }
            } else {
                if (repositoryName == null) {
                    repositoryName = "";
                } else if (workspaceName == null) {
                    workspaceName = "";
                }
                nodePath = nodePath.replaceAll("/{2,}+", ROOT_NODE_PATH);
            }
            return new ResolvedRequest(request, repositoryName, workspaceName, nodePath);
        }
        return new ResolvedRequest(request, null, null, null);
    }
}

