/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.schema;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.JsonSchema;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.schematic.internal.schema.Problems;
import org.infinispan.schematic.internal.schema.SchemaDocument;
import org.infinispan.schematic.internal.schema.ValidationResult;
import org.infinispan.schematic.internal.schema.Validator;

public class JsonSchemaValidatorFactory
implements Validator.Factory {
    private CompositeValidator topLevelValidator = new CompositeValidator();
    private final Problems problems;
    private final URI uri;

    protected JsonSchemaValidatorFactory(URI uri, Problems problems) {
        this.uri = uri;
        this.problems = problems;
    }

    @Override
    public Validator create(Document schemaDocument, Path pathToDoc) {
        Validator derefValidator;
        CompositeValidator validators = new CompositeValidator();
        if (this.topLevelValidator == null) {
            this.topLevelValidator = validators;
        }
        if ((derefValidator = this.dereference(schemaDocument, pathToDoc, this.problems)) != null) {
            return derefValidator;
        }
        this.addValidatorsForTypes(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForProperties(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForPatternProperties(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForItems(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForRequired(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForMinimum(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForMaximum(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForMinimumItems(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForMaximumItems(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForUniqueItems(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForPattern(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForMinimumLength(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForMaximumLength(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForEnum(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForDivisibleBy(schemaDocument, pathToDoc, this.problems, validators);
        this.addValidatorsForDisallowedTypes(schemaDocument, pathToDoc, this.problems, validators);
        switch (validators.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return validators.getFirst();
            }
        }
        return validators;
    }

    protected Validator dereference(Document schemaDocument, Path pathToDoc, Problems problems) {
        String ref = schemaDocument.getString("$ref");
        if (ref == null) {
            return null;
        }
        if ("#".equals(ref)) {
            return this.topLevelValidator;
        }
        String resolvedReference = null;
        URI refUri = null;
        try {
            refUri = new URI(ref);
            URI resolvedUri = this.uri.resolve(refUri);
            resolvedReference = resolvedUri.toString();
        }
        catch (URISyntaxException e) {
            problems.recordWarning(pathToDoc, "The URI of the referenced schema '" + this.uri + "' is not a valid URI");
        }
        if (this.uri.equals(resolvedReference)) {
            return this.topLevelValidator;
        }
        if (!ref.equals(resolvedReference)) {
            assert (resolvedReference != null);
            return new ResolvingValidator(resolvedReference);
        }
        return null;
    }

    protected void addValidatorsForTypes(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        Object value = parent.get("type");
        if (value instanceof String) {
            JsonSchema.Type type = JsonSchema.Type.byName((String)value);
            if (type == JsonSchema.Type.ANY || type == JsonSchema.Type.UNKNOWN) {
                return;
            }
            validators.add(new TypeValidator(type));
        } else if (value instanceof List) {
            ArrayList<Validator> unionValidators = new ArrayList<Validator>();
            List types = (List)value;
            for (Object obj : types) {
                Validator validator = null;
                if (obj instanceof Document) {
                    Document schemaOrRef = (Document)obj;
                    validator = this.create(schemaOrRef, parentPath.with("type"));
                } else if (obj instanceof String) {
                    JsonSchema.Type type = JsonSchema.Type.byName((String)obj);
                    if (type == JsonSchema.Type.ANY || type == JsonSchema.Type.UNKNOWN) continue;
                    validator = new TypeValidator(type);
                }
                if (validator == null) continue;
                unionValidators.add(validator);
            }
            if (unionValidators.size() == 1) {
                validators.add((Validator)unionValidators.get(0));
            } else if (unionValidators.size() > 1) {
                validators.add(new UnionValidator(unionValidators));
            }
        }
    }

    protected void addValidatorsForProperties(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        boolean additionalPropertiesAllowed;
        Document properties = parent.getDocument("properties");
        HashSet<String> propertiesWithSchemas = new HashSet<String>();
        if (properties != null && properties.size() != 0) {
            for (Document.Field field : properties.fields()) {
                Document propertySchema;
                Validator propertyValidator;
                String name = field.getName();
                Object value = field.getValue();
                Path path = Paths.path(parentPath, "properties", name);
                if (!(value instanceof Document)) {
                    problems.recordError(path, "Expected a nested object");
                }
                if ((propertyValidator = this.create(propertySchema = (Document)value, path)) != null) {
                    validators.add(new PropertyValidator(name, propertyValidator));
                }
                propertiesWithSchemas.add(name);
            }
        }
        if (!(additionalPropertiesAllowed = parent.getBoolean("additionalProperties", true))) {
            validators.add(new NoOtherAllowedPropertiesValidator(propertiesWithSchemas));
        } else {
            Path path;
            Validator additionalValidator;
            Document additionalSchema = parent.getDocument("additionalProperties");
            if (additionalSchema != null && (additionalValidator = this.create(additionalSchema, path = parentPath.with("additionalProperties"))) != null) {
                validators.add(new AllowedPropertiesValidator(propertiesWithSchemas, additionalValidator));
            }
        }
    }

    protected void addValidatorsForPatternProperties(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        Document properties = parent.getDocument("patternProperties");
        if (properties != null && properties.size() != 0) {
            for (Document.Field field : properties.fields()) {
                String name = field.getName();
                Object value = field.getValue();
                Path path = Paths.path(parentPath, "patternProperties", name);
                if (!(value instanceof Document)) {
                    problems.recordError(path, "Expected a nested object");
                }
                Document propertySchema = (Document)value;
                try {
                    Pattern namePattern = Pattern.compile(name);
                    Validator propertyValidator = this.create(propertySchema, path);
                    if (propertyValidator == null) continue;
                    validators.add(new PatternPropertyValidator(namePattern, propertyValidator));
                }
                catch (PatternSyntaxException e) {
                    problems.recordError(path, "Expected the field name to be a regular expression");
                }
            }
        }
    }

    protected void addValidatorsForItems(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        Object items = parent.get("items");
        if (Null.matches(items)) {
            return;
        }
        Path path = parentPath.with("items");
        String requiredName = parentPath.getLast();
        if (requiredName == null) {
            return;
        }
        if (items instanceof Document) {
            Document schema = (Document)items;
            Validator validator = this.create(schema, path);
            if (validator != null) {
                validators.add(new AllItemsMatchValidator(requiredName, validator));
            }
        } else if (items instanceof List) {
            List array = (List)items;
            ArrayList<Validator> itemValidators = new ArrayList<Validator>(array.size());
            for (Object item : array) {
                Validator validator;
                if (!(item instanceof Document) || (validator = this.create((Document)item, path)) == null) continue;
                itemValidators.add(validator);
            }
            boolean additionalItemsAllowed = parent.getBoolean("additionalItems", true);
            Validator additionalItemsValidator = null;
            if (!additionalItemsAllowed) {
                additionalItemsValidator = new NotValidValidator();
            } else {
                Document additionalItems = parent.getDocument("additionalItems");
                if (additionalItems != null) {
                    Path additionalItemsPath = parentPath.with("additionalItems");
                    additionalItemsValidator = this.create(additionalItems, additionalItemsPath);
                }
            }
            if (!itemValidators.isEmpty()) {
                validators.add(new EachItemMatchesValidator(requiredName, itemValidators, additionalItemsValidator, additionalItemsAllowed));
            }
        }
    }

    protected void addValidatorsForRequired(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        Boolean required = parent.getBoolean("required", Boolean.FALSE);
        if (required.booleanValue() && (requiredName = parentPath.getLast()) != null) {
            validators.add(new RequiredValidator(requiredName));
        }
    }

    protected void addValidatorsForMinimum(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        Number minimum = parent.getNumber("minimum");
        if (minimum != null && (requiredName = parentPath.getLast()) != null) {
            if (parent.getBoolean("exclusiveMinimum", Boolean.FALSE)) {
                validators.add(new ExclusiveMinimumValidator(requiredName, minimum));
            } else {
                validators.add(new MinimumValidator(requiredName, minimum));
            }
        }
    }

    protected void addValidatorsForMaximum(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        Double maximum = parent.getDouble("maximum");
        if (maximum != null && (requiredName = parentPath.getLast()) != null) {
            if (parent.getBoolean("exclusiveMinimum", Boolean.FALSE)) {
                validators.add(new ExclusiveMaximumValidator(requiredName, maximum));
            } else {
                validators.add(new MaximumValidator(requiredName, maximum));
            }
        }
    }

    protected void addValidatorsForMinimumItems(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        int minimum = parent.getInteger("minItems", 0);
        if (minimum > 0 && (requiredName = parentPath.getLast()) != null) {
            validators.add(new MinimumItemsValidator(requiredName, minimum));
        }
    }

    protected void addValidatorsForMaximumItems(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        int maximum = parent.getInteger("maxItems", 0);
        if (maximum > 0 && (requiredName = parentPath.getLast()) != null) {
            validators.add(new MaximumItemsValidator(requiredName, maximum));
        }
    }

    protected void addValidatorsForUniqueItems(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        if (parent.getBoolean("uniqueItems", false) && (requiredName = parentPath.getLast()) != null) {
            validators.add(new UniqueItemsValidator(requiredName));
        }
    }

    protected void addValidatorsForPattern(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        String regex = parent.getString("pattern");
        if (regex != null && (requiredName = parentPath.getLast()) != null) {
            try {
                Pattern pattern = Pattern.compile(regex);
                validators.add(new PatternValidator(requiredName, pattern));
            }
            catch (PatternSyntaxException e) {
                problems.recordError(parentPath.with("pattern"), "The supplied value '" + regex + "' is expected to be a valid regular expression, but there was an error at position " + e.getIndex() + ": " + e.getDescription());
            }
        }
    }

    protected void addValidatorsForMinimumLength(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        int minimumLength = parent.getInteger("minimumLength", 0);
        if (minimumLength > 0 && (requiredName = parentPath.getLast()) != null) {
            validators.add(new MinimumLengthValidator(requiredName, minimumLength));
        }
    }

    protected void addValidatorsForMaximumLength(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        int maximumLength = parent.getInteger("maximumLength", 0);
        if (maximumLength > 0 && (requiredName = parentPath.getLast()) != null) {
            validators.add(new MaximumLengthValidator(requiredName, maximumLength));
        }
    }

    protected void addValidatorsForEnum(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        List<?> enumValues = parent.getArray("enum");
        if (enumValues != null && !enumValues.isEmpty() && (requiredName = parentPath.getLast()) != null) {
            validators.add(new EnumValidator(requiredName, enumValues));
        }
    }

    protected void addValidatorsForDivisibleBy(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        String requiredName;
        int denominatorIntValue;
        Number denominator = parent.getNumber("divisibleBy", 1);
        if (denominator != null && (denominatorIntValue = denominator.intValue()) != 0 && denominatorIntValue != 1 && (requiredName = parentPath.getLast()) != null) {
            validators.add(new DivisibleByValidator(requiredName, denominator.intValue()));
        }
    }

    protected void addValidatorsForDisallowedTypes(Document parent, Path parentPath, Problems problems, CompositeValidator validators) {
        Object disallowed = parent.get("disallowed");
        if (Null.matches(disallowed)) {
            return;
        }
        String requiredName = parentPath.getLast();
        if (requiredName != null) {
            EnumSet<JsonSchema.Type> disallowedTypes = JsonSchema.Type.typesWithNames(disallowed);
            validators.add(new DisallowedTypesValidator(requiredName, disallowedTypes));
        }
    }

    protected static String th(int i) {
        switch (i) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    protected static RequiredValidator getRequiredValidator(Validator validator) {
        if (validator instanceof RequiredValidator) {
            return (RequiredValidator)validator;
        }
        if (validator instanceof ValidatorCollection) {
            for (Validator val : (ValidatorCollection)((Object)validator)) {
                if (!(val instanceof RequiredValidator)) continue;
                return (RequiredValidator)val;
            }
        }
        return null;
    }

    protected static class SingleProblem
    implements Problems {
        private static final long serialVersionUID = 1L;
        private SchemaLibrary.ProblemType type;
        private Path path;
        private String message;
        private Throwable exception;
        private Object actualValue;
        private Object convertedValue;
        private JsonSchema.Type actualType;
        private JsonSchema.Type requiredType;
        private boolean mismatch = false;
        private boolean success = false;

        protected SingleProblem() {
        }

        @Override
        public void recordSuccess() {
            this.success = true;
        }

        @Override
        public void recordError(Path path, String message) {
            this.type = SchemaLibrary.ProblemType.ERROR;
            this.path = path;
            this.message = message;
            this.exception = null;
            this.actualValue = null;
            this.convertedValue = null;
            this.actualType = null;
            this.requiredType = null;
            this.mismatch = false;
            this.success = false;
        }

        @Override
        public void recordError(Path path, String message, Throwable exception) {
            this.type = SchemaLibrary.ProblemType.ERROR;
            this.path = path;
            this.message = message;
            this.exception = exception;
            this.actualValue = null;
            this.convertedValue = null;
            this.actualType = null;
            this.requiredType = null;
            this.mismatch = false;
            this.success = false;
        }

        @Override
        public void recordWarning(Path path, String message) {
            this.type = SchemaLibrary.ProblemType.WARNING;
            this.path = path;
            this.message = message;
            this.exception = null;
            this.actualValue = null;
            this.convertedValue = null;
            this.actualType = null;
            this.requiredType = null;
            this.mismatch = false;
            this.success = false;
        }

        @Override
        public void recordTypeMismatch(Path path, String message, JsonSchema.Type actualType, Object actualValue, JsonSchema.Type requiredType, Object convertedValue) {
            this.type = SchemaLibrary.ProblemType.ERROR;
            this.path = path;
            this.message = message;
            this.exception = null;
            this.actualValue = actualValue;
            this.convertedValue = convertedValue;
            this.actualType = actualType;
            this.requiredType = requiredType;
            this.mismatch = true;
            this.success = false;
        }

        public boolean hasProblem() {
            return this.type != null;
        }

        public void recordIn(Problems otherProblems) {
            if (this.success) {
                otherProblems.recordSuccess();
                return;
            }
            switch (this.type) {
                case ERROR: {
                    if (this.mismatch) {
                        otherProblems.recordTypeMismatch(this.path, this.message, this.actualType, this.actualValue, this.requiredType, this.convertedValue);
                        break;
                    }
                    otherProblems.recordError(this.path, this.message, this.exception);
                    break;
                }
                case WARNING: {
                    otherProblems.recordWarning(this.path, this.message);
                }
            }
        }

        public void clear() {
            this.type = null;
            this.success = false;
        }
    }

    protected static class CompositeValidator
    implements Validator,
    ValidatorCollection {
        private static final long serialVersionUID = 1L;
        private final List<Validator> validators = new ArrayList<Validator>();

        protected void add(Validator validator) {
            this.validators.add(validator);
        }

        protected int size() {
            return this.validators.size();
        }

        protected Validator getFirst() {
            return this.validators.get(0);
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            for (Validator validator : this.validators) {
                try {
                    validator.validate(fieldValue, fieldName, parent, pathToParent, problems, resolver);
                }
                catch (Throwable t) {
                    problems.recordError(pathToParent, t.getMessage(), t);
                }
            }
        }

        @Override
        public Iterator<Validator> iterator() {
            return this.validators.iterator();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Validator validator : this.validators) {
                sb.append(validator.toString());
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    protected static class NoOtherAllowedPropertiesValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final Set<String> allowedPropertyNames;

        public NoOtherAllowedPropertiesValidator(Set<String> allowedPropertyNames) {
            this.allowedPropertyNames = allowedPropertyNames;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue == null) {
                if (fieldName == null) {
                    for (Document.Field field : parent.fields()) {
                        this.validate(field.getValue(), field.getName(), parent, pathToParent, problems, resolver);
                    }
                }
            } else if (!this.allowedPropertyNames.contains(fieldName)) {
                problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' is not defined in the schema and the schema does not allow additional properties.");
            } else {
                problems.recordSuccess();
            }
        }

        public String toString() {
            return "additional properties not allowed";
        }
    }

    protected static class AllowedPropertiesValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final Set<String> allowedPropertyNames;
        private final Validator validator;

        public AllowedPropertiesValidator(Set<String> allowedPropertyNames, Validator validator) {
            this.allowedPropertyNames = allowedPropertyNames;
            this.validator = validator;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldName != null && !this.allowedPropertyNames.contains(fieldName)) {
                this.validator.validate(fieldValue, fieldName, parent, pathToParent, problems, resolver);
            } else if (fieldName == null) {
                for (Document.Field field : parent.fields()) {
                    if (field.getValue() instanceof Document) {
                        this.validator.validate(null, null, (Document)field.getValue(), pathToParent.with(field.getName()), problems, resolver);
                        continue;
                    }
                    this.validator.validate(field.getValue(), field.getName(), parent, pathToParent, problems, resolver);
                }
            }
        }

        public String toString() {
            return "additional properties allowed: " + this.validator.toString();
        }
    }

    protected static class PatternPropertyValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final Pattern propertyNamePattern;
        private final Validator validator;

        public PatternPropertyValidator(Pattern propertyNamePattern, Validator validator) {
            this.propertyNamePattern = propertyNamePattern;
            this.validator = validator;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue == null) {
                return;
            }
            Matcher matcher = this.propertyNamePattern.matcher(fieldName);
            if (matcher.matches()) {
                this.validator.validate(fieldValue, fieldName, parent, pathToParent, problems, resolver);
            }
        }

        public String toString() {
            return "pattern property '" + this.propertyNamePattern.pattern() + "': " + this.validator.toString();
        }
    }

    protected static class PropertyValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final Validator validator;
        private final RequiredValidator required;

        public PropertyValidator(String propertyName, Validator validator) {
            this.propertyName = propertyName;
            this.validator = validator;
            this.required = JsonSchemaValidatorFactory.getRequiredValidator(validator);
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldName == null) {
                fieldName = this.propertyName;
            }
            if (fieldValue == null) {
                fieldValue = parent.get(this.propertyName);
            }
            if (fieldValue == null) {
                if (this.required != null) {
                    this.required.validate(fieldValue, fieldName, parent, pathToParent, problems, resolver);
                }
                return;
            }
            if (fieldValue instanceof Document) {
                this.validator.validate(null, null, (Document)fieldValue, pathToParent.with(fieldName), problems, resolver);
            } else {
                this.validator.validate(fieldValue, fieldName, parent, pathToParent, problems, resolver);
            }
        }

        public String toString() {
            return "property '" + this.propertyName + "': " + this.validator.toString();
        }
    }

    protected static class NotValidValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            problems.recordError(pathToParent, "");
        }

        public String toString() {
            return "not valid";
        }
    }

    protected static class EachItemMatchesValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final List<Validator> itemValidators;
        private final Validator additionalItemsValidator;
        private final SingleProblem itemProblems = new SingleProblem();
        private final boolean additionalItemsAllowed;

        public EachItemMatchesValidator(String propertyName, List<Validator> itemValidators, Validator additionalItemsValidator, boolean additionalItemsAllowed) {
            this.propertyName = propertyName;
            this.itemValidators = itemValidators;
            this.additionalItemsValidator = additionalItemsValidator;
            this.additionalItemsAllowed = additionalItemsAllowed;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof List) {
                Object item;
                List items = (List)fieldValue;
                Path path = pathToParent.with(fieldName);
                int i = 0;
                Iterator itemIterator = items.iterator();
                Iterator<Validator> itemValidatorIterator = this.itemValidators.iterator();
                boolean success = true;
                while (itemIterator.hasNext() && itemValidatorIterator.hasNext()) {
                    ++i;
                    item = itemIterator.next();
                    Validator itemValidator = itemValidatorIterator.next();
                    itemValidator.validate(item, fieldName, parent, pathToParent, this.itemProblems, resolver);
                }
                if (this.additionalItemsAllowed && this.additionalItemsValidator != null) {
                    while (itemIterator.hasNext()) {
                        ++i;
                        item = itemIterator.next();
                        this.itemProblems.clear();
                        this.additionalItemsValidator.validate(item, fieldName, parent, pathToParent, this.itemProblems, resolver);
                        if (!this.itemProblems.hasProblem()) continue;
                        problems.recordError(path, "The '" + fieldName + "' field on '" + pathToParent + "' is an array, but the " + i + JsonSchemaValidatorFactory.th(i) + " item does have a corresponding schema and does not satisfy the additional items schema)");
                        success = false;
                    }
                } else if (!this.additionalItemsAllowed) {
                    while (itemIterator.hasNext()) {
                        problems.recordError(path, "The '" + fieldName + "' field on '" + pathToParent + "' is an array, but the " + ++i + JsonSchemaValidatorFactory.th(i) + " item does have a corresponding schema (and no additional items were specified)");
                        success = false;
                    }
                }
                if (success) {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' may be an array with items matching the schemas: " + this.itemValidators + (this.additionalItemsValidator == null ? "" : " or the additional items schema " + this.additionalItemsValidator);
        }
    }

    protected static class AllItemsMatchValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final Validator itemValidator;
        private final SingleProblem itemProblems = new SingleProblem();

        public AllItemsMatchValidator(String propertyName, Validator itemValidator) {
            this.propertyName = propertyName;
            this.itemValidator = itemValidator;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof List) {
                List items = (List)fieldValue;
                Path path = pathToParent.with(fieldName);
                int i = 1;
                boolean success = true;
                for (Object item : items) {
                    this.itemProblems.clear();
                    this.itemValidator.validate(item, fieldName, parent, pathToParent, this.itemProblems, resolver);
                    if (this.itemProblems.hasProblem()) {
                        problems.recordError(path, "The '" + fieldName + "' field on '" + pathToParent + "' is an array, but the " + i + JsonSchemaValidatorFactory.th(i) + " item does not satisfy the schema for the " + i + JsonSchemaValidatorFactory.th(i) + " item");
                        success = false;
                    }
                    ++i;
                }
                if (success) {
                    problems.recordSuccess();
                }
            } else if (parent instanceof List) {
                List items = (List)((Object)parent);
                int i = 1;
                boolean success = true;
                for (Object item : items) {
                    this.itemProblems.clear();
                    if (item instanceof Document) {
                        this.itemValidator.validate(null, null, (Document)item, pathToParent, this.itemProblems, resolver);
                        if (this.itemProblems.hasProblem()) {
                            success = false;
                        }
                    } else {
                        fieldName = item.toString();
                        Path path = pathToParent.with(fieldName);
                        this.itemValidator.validate(item, fieldName, parent, pathToParent, this.itemProblems, resolver);
                        if (this.itemProblems.hasProblem()) {
                            problems.recordError(path, "The '" + fieldName + "' field on '" + pathToParent + "' is an array, but the " + i + JsonSchemaValidatorFactory.th(i) + " item does not satisfy the schema for the " + i + JsonSchemaValidatorFactory.th(i) + " item");
                            success = false;
                        }
                    }
                    ++i;
                }
                if (success) {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' may be an array with items matching the schema: " + this.itemValidator;
        }
    }

    protected static class DisallowedTypesValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final EnumSet<JsonSchema.Type> disallowedTypes;

        public DisallowedTypesValidator(String propertyName, EnumSet<JsonSchema.Type> disallowedTypes) {
            this.propertyName = propertyName;
            this.disallowedTypes = disallowedTypes;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            JsonSchema.Type type = JsonSchema.Type.typeFor(fieldValue);
            if (type != JsonSchema.Type.NULL) {
                if (this.disallowedTypes.contains((Object)type)) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' contains a value '" + fieldValue + "' whose type '" + (Object)((Object)type) + "' is disallowed.");
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' may not have values with the types " + this.disallowedTypes;
        }
    }

    protected static class EnumValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final Set<String> values;

        public EnumValidator(String propertyName, Collection<?> values) {
            this.propertyName = propertyName;
            this.values = new HashSet<String>(values.size());
            for (Object value : values) {
                this.values.add(value.toString().toLowerCase());
            }
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (!this.propertyName.equals(fieldName)) {
                return;
            }
            if (fieldValue instanceof List) {
                for (Object value : (List)fieldValue) {
                    if (this.values.contains(value.toString().toLowerCase())) {
                        problems.recordSuccess();
                        continue;
                    }
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' contains a value '" + value + "' in the array that is not part of the enumeration: " + this.values);
                }
            } else if (fieldValue != null) {
                if (this.values.contains(fieldValue.toString().toLowerCase())) {
                    problems.recordSuccess();
                } else {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' has a value of '" + fieldValue + "' that is not part of the enumeration: " + this.values);
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' contains values from enumeration: " + this.values;
        }
    }

    protected static class PatternValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final Pattern pattern;

        public PatternValidator(String propertyName, Pattern pattern) {
            this.propertyName = propertyName;
            this.pattern = pattern;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof String || fieldValue instanceof Symbol) {
                String value = fieldValue.toString();
                Matcher matcher = this.pattern.matcher(value);
                if (!matcher.matches()) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' failed match the pattern specified by '" + this.pattern.pattern() + "'");
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' matches pattern '" + this.pattern.pattern() + "'";
        }
    }

    protected static class UniqueItemsValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;

        public UniqueItemsValidator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof List) {
                List array = (List)fieldValue;
                HashSet uniqueValues = new HashSet(array);
                int numDups = array.size() - uniqueValues.size();
                if (numDups != 0) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' must contain unique values, but contains " + numDups + " duplicate values");
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' contains unique items";
        }
    }

    protected static class MaximumItemsValidator
    extends ItemCountValidator {
        private static final long serialVersionUID = 1L;

        public MaximumItemsValidator(String propertyName, int maximum) {
            super(propertyName, maximum);
        }

        @Override
        protected boolean evaluate(double maximumCount, double actualCount) {
            return maximumCount < actualCount;
        }

        @Override
        protected String ruleDescription() {
            return "no more than";
        }
    }

    protected static class MinimumItemsValidator
    extends ItemCountValidator {
        private static final long serialVersionUID = 1L;

        public MinimumItemsValidator(String propertyName, int minimum) {
            super(propertyName, minimum);
        }

        @Override
        protected boolean evaluate(double minimumCount, double actualCount) {
            return minimumCount < actualCount;
        }

        @Override
        protected String ruleDescription() {
            return "at least";
        }
    }

    protected static abstract class ItemCountValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int number;

        protected ItemCountValidator(String propertyName, int number) {
            this.propertyName = propertyName;
            this.number = number;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof List) {
                List array = (List)fieldValue;
                if (this.evaluate(this.number, array.size())) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' has '" + array.size() + "' values but should have " + this.ruleDescription() + " '" + this.number + "'");
                } else {
                    problems.recordSuccess();
                }
            }
        }

        protected abstract boolean evaluate(double var1, double var3);

        protected abstract String ruleDescription();

        public String toString() {
            return "'" + this.propertyName + "' has '" + this.ruleDescription() + " '" + this.number + "' items";
        }
    }

    protected static class DivisibleByValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int denominator;

        public DivisibleByValidator(String propertyName, int denominator) {
            this.propertyName = propertyName;
            this.denominator = denominator;
            assert (this.denominator != 0);
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (Null.matches(fieldValue)) {
                return;
            }
            if (fieldValue instanceof Integer) {
                int value = (Integer)fieldValue;
                if (value % this.denominator != 0) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had a value of " + value + " and was not divisible by " + this.denominator);
                } else {
                    problems.recordSuccess();
                }
            } else if (fieldValue instanceof Long) {
                long value = (Long)fieldValue;
                if (value % (long)this.denominator != 0L) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had a value of " + value + " and was not divisible by " + this.denominator);
                } else {
                    problems.recordSuccess();
                }
            } else if (fieldValue instanceof Short) {
                int value = ((Short)fieldValue).intValue();
                if (value % this.denominator != 0) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had a value of " + value + " and was not divisible by " + this.denominator);
                } else {
                    problems.recordSuccess();
                }
            } else if (fieldValue instanceof Float) {
                float value = ((Float)fieldValue).floatValue();
                if (value % (float)this.denominator != 0.0f) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had a value of " + value + " and was not divisible by " + this.denominator);
                } else {
                    problems.recordSuccess();
                }
            } else if (fieldValue instanceof Double) {
                double value = ((Double)fieldValue).floatValue();
                if (value % (double)this.denominator != 0.0) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had a value of " + value + " and was not divisible by " + this.denominator);
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' must be divisible by " + this.denominator;
        }
    }

    protected static class MaximumLengthValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int maximumLength;

        public MaximumLengthValidator(String propertyName, int maximumLength) {
            this.propertyName = propertyName;
            this.maximumLength = maximumLength;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof String || fieldValue instanceof Symbol) {
                String value = fieldValue.toString();
                if (value.length() > this.maximumLength) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had " + value.length() + " characters, but was expected to have no more than " + this.maximumLength);
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' has a maximum length of " + this.maximumLength;
        }
    }

    protected static class MinimumLengthValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final int minimumLength;

        public MinimumLengthValidator(String propertyName, int minimumLength) {
            this.propertyName = propertyName;
            this.minimumLength = minimumLength;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof String || fieldValue instanceof Symbol) {
                String value = fieldValue.toString();
                if (value.length() < this.minimumLength) {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' had " + value.length() + " characters, but was expected to have at least " + this.minimumLength);
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "'" + this.propertyName + "' has a minimum length of " + this.minimumLength;
        }
    }

    protected static class ExclusiveMaximumValidator
    extends NumericValidator {
        private static final long serialVersionUID = 1L;

        public ExclusiveMaximumValidator(String propertyName, Number maximum) {
            super(propertyName, maximum);
        }

        @Override
        protected boolean isValid(double maximum, double actualValue) {
            return actualValue < maximum;
        }

        @Override
        protected String ruleDescription() {
            return "less than";
        }
    }

    protected static class MaximumValidator
    extends NumericValidator {
        private static final long serialVersionUID = 1L;

        public MaximumValidator(String propertyName, Number maximum) {
            super(propertyName, maximum);
        }

        @Override
        protected boolean isValid(double maximum, double actualValue) {
            return actualValue <= maximum;
        }

        @Override
        protected String ruleDescription() {
            return "less than or equal to";
        }
    }

    protected static class ExclusiveMinimumValidator
    extends NumericValidator {
        private static final long serialVersionUID = 1L;

        public ExclusiveMinimumValidator(String propertyName, Number minimum) {
            super(propertyName, minimum);
        }

        @Override
        protected boolean isValid(double minimum, double actualValue) {
            return actualValue > minimum;
        }

        @Override
        protected String ruleDescription() {
            return "greater than";
        }
    }

    protected static class MinimumValidator
    extends NumericValidator {
        private static final long serialVersionUID = 1L;

        public MinimumValidator(String propertyName, Number minimum) {
            super(propertyName, minimum);
        }

        @Override
        protected boolean isValid(double minimum, double actualValue) {
            return actualValue >= minimum;
        }

        @Override
        protected String ruleDescription() {
            return "greater than or equal to";
        }
    }

    protected static abstract class NumericValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;
        private final Number number;
        private final double value;

        protected NumericValidator(String propertyName, Number number) {
            this.propertyName = propertyName;
            this.number = number;
            this.value = number.doubleValue();
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue instanceof Number) {
                Number actualNumber = (Number)fieldValue;
                double actualValue = actualNumber.doubleValue();
                if (this.isValid(this.value, actualValue)) {
                    problems.recordSuccess();
                } else {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' is '" + actualNumber + "' but must be " + this.ruleDescription() + " '" + this.number + "'");
                }
            }
        }

        protected abstract boolean isValid(double var1, double var3);

        protected abstract String ruleDescription();

        public String toString() {
            return "'" + this.propertyName + "' is '" + this.ruleDescription() + " '" + this.number + "'";
        }
    }

    protected static class RequiredValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String propertyName;

        public RequiredValidator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document parent, Path pathToParent, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (Null.matches(fieldValue) && fieldName != null) {
                if (pathToParent.size() == 0) {
                    problems.recordError(pathToParent.with(fieldName), "The top-level '" + fieldName + "' field is required");
                } else {
                    problems.recordError(pathToParent.with(fieldName), "The '" + fieldName + "' field on '" + pathToParent + "' is required");
                }
            } else {
                problems.recordSuccess();
            }
        }

        public String toString() {
            return "required '" + this.propertyName + "'";
        }
    }

    protected class ResolvingValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final String schemaUri;

        public ResolvingValidator(String schemaUri) {
            this.schemaUri = schemaUri;
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document document, Path pathToDocument, Problems problems, Validator.SchemaDocumentResolver resolver) {
            SchemaDocument resolved = resolver.get(this.schemaUri, problems);
            if (resolved == null) {
                problems.recordError(pathToDocument.with(fieldName), "Unable to find referenced schema '" + this.schemaUri + "'");
            } else {
                problems.recordSuccess();
                resolved.getValidator().validate(fieldValue, fieldName, document, pathToDocument, problems, resolver);
            }
        }

        public String toString() {
            return "Resolves to schema '" + this.schemaUri + "'";
        }
    }

    protected class UnionValidator
    implements Validator,
    ValidatorCollection {
        private static final long serialVersionUID = 1L;
        private final List<Validator> validators;

        public UnionValidator(List<Validator> validators) {
            this.validators = validators;
            assert (this.validators != null && !this.validators.isEmpty());
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document document, Path pathToDocument, Problems problems, Validator.SchemaDocumentResolver resolver) {
            ValidationResult problemsForMostSuccesses = null;
            int mostSuccesses = -1;
            for (Validator validator : this.validators) {
                ValidationResult newProblems = new ValidationResult();
                validator.validate(fieldValue, fieldName, document, pathToDocument, newProblems, resolver);
                if (!newProblems.hasErrors()) {
                    problems.recordSuccess();
                    return;
                }
                if (newProblems.successCount() <= mostSuccesses) continue;
                mostSuccesses = newProblems.successCount();
                problemsForMostSuccesses = newProblems;
            }
            if (problemsForMostSuccesses != null) {
                problemsForMostSuccesses.recordIn(problems);
            }
        }

        @Override
        public Iterator<Validator> iterator() {
            return this.validators.iterator();
        }

        public String toString() {
            return "Union of " + this.validators.size() + " validators";
        }
    }

    protected static interface ValidatorCollection
    extends Iterable<Validator> {
    }

    protected class TypeValidator
    implements Validator {
        private static final long serialVersionUID = 1L;
        private final JsonSchema.Type type;

        public TypeValidator(JsonSchema.Type type) {
            this.type = type;
            assert (this.type != null);
        }

        @Override
        public void validate(Object fieldValue, String fieldName, Document document, Path pathToDocument, Problems problems, Validator.SchemaDocumentResolver resolver) {
            if (fieldValue == null) {
                fieldValue = fieldName != null ? document.get(fieldName) : document;
            }
            if (fieldValue != null) {
                JsonSchema.Type actual = JsonSchema.Type.typeFor(fieldValue);
                if (!this.type.isEquivalent(actual)) {
                    Object converted = this.type.convertValueFrom(fieldValue, actual);
                    Path pathToField = fieldName != null ? pathToDocument.with(fieldName) : pathToDocument;
                    String reason = "Field value for '" + pathToField + "' expected to be of type " + (Object)((Object)this.type) + " but was of type " + (Object)((Object)actual);
                    if (converted != null) {
                        problems.recordTypeMismatch(pathToField, reason, actual, fieldValue, this.type, converted);
                    } else {
                        problems.recordError(pathToField, reason);
                    }
                } else {
                    problems.recordSuccess();
                }
            }
        }

        public String toString() {
            return "Type is '" + (Object)((Object)this.type) + "'";
        }
    }
}

