/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyDecimal;
import org.apache.chemistry.opencmis.commons.data.PropertyHtml;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.PropertyUri;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.jcr.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JcrConverter {
    private JcrConverter() {
    }

    public static String toJcrName(String cmisName) {
        StringBuilder buffer = new StringBuilder(cmisName.length() * 2);
        for (int i = 0; i < cmisName.length(); ++i) {
            char ch = cmisName.charAt(i);
            if (ch == '%' || ch == '/' || ch == ':' || ch == '[' || ch == ']' || ch == '*' || ch == '|' || ch == '\t' || ch == '\r' || ch == '\n' || ch == '.' && cmisName.length() < 3 || ch == ' ' && (i == 0 || i == cmisName.length() - 1)) {
                buffer.append('%');
                buffer.append(Character.toUpperCase(Character.forDigit(ch / 16, 16)));
                buffer.append(Character.toUpperCase(Character.forDigit(ch % 16, 16)));
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static boolean isValidJcrName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != '%' && ch != '/' && ch != ':' && ch != '[' && ch != ']' && ch != '*' && ch != '|' && ch != '\t' && ch != '\r' && ch != '\n' && (ch != '.' || name.length() >= 3) && (ch != ' ' || i != 0 && i != name.length() - 1)) continue;
            return false;
        }
        return true;
    }

    public static PropertyData<?> convert(Property jcrProperty) throws RepositoryException {
        PropertyStringImpl propertyData;
        switch (jcrProperty.getType()) {
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                propertyData = jcrProperty.isMultiple() ? new PropertyStringImpl(jcrProperty.getName(), JcrConverter.toStrings(jcrProperty.getValues())) : new PropertyStringImpl(jcrProperty.getName(), jcrProperty.getString());
                break;
            }
            case 3: {
                propertyData = jcrProperty.isMultiple() ? new PropertyIntegerImpl(jcrProperty.getName(), JcrConverter.toInts(jcrProperty.getValues())) : new PropertyIntegerImpl(jcrProperty.getName(), BigInteger.valueOf(jcrProperty.getLong()));
                break;
            }
            case 12: {
                propertyData = jcrProperty.isMultiple() ? new PropertyDecimalImpl(jcrProperty.getName(), JcrConverter.toDecs(jcrProperty.getValues())) : new PropertyDecimalImpl(jcrProperty.getName(), jcrProperty.getDecimal());
                break;
            }
            case 4: {
                propertyData = jcrProperty.isMultiple() ? new PropertyDecimalImpl(jcrProperty.getName(), JcrConverter.doublesToDecs(jcrProperty.getValues())) : new PropertyDecimalImpl(jcrProperty.getName(), BigDecimal.valueOf(jcrProperty.getDouble()));
                break;
            }
            case 5: {
                propertyData = jcrProperty.isMultiple() ? new PropertyDateTimeImpl(jcrProperty.getName(), JcrConverter.toDates(jcrProperty.getValues())) : new PropertyDateTimeImpl(jcrProperty.getName(), Util.toCalendar(jcrProperty.getDate()));
                break;
            }
            case 6: {
                propertyData = jcrProperty.isMultiple() ? new PropertyBooleanImpl(jcrProperty.getName(), JcrConverter.toBools(jcrProperty.getValues())) : new PropertyBooleanImpl(jcrProperty.getName(), Boolean.valueOf(jcrProperty.getBoolean()));
                break;
            }
            case 11: {
                propertyData = jcrProperty.isMultiple() ? new PropertyUriImpl(jcrProperty.getName(), JcrConverter.toStrings(jcrProperty.getValues())) : new PropertyUriImpl(jcrProperty.getName(), jcrProperty.getString());
                break;
            }
            default: {
                throw new CmisInvalidArgumentException("Invalid property type: " + jcrProperty.getType());
            }
        }
        propertyData.setDisplayName(jcrProperty.getName());
        propertyData.setLocalName(jcrProperty.getName());
        propertyData.setQueryName(jcrProperty.getName());
        return propertyData;
    }

    public static void setProperty(Node node, PropertyData<?> propertyData) throws RepositoryException {
        String name;
        int propertyType;
        Value[] values;
        if (propertyData instanceof PropertyBoolean) {
            values = JcrConverter.toValue((PropertyBoolean)propertyData, node.getSession().getValueFactory());
            propertyType = 6;
        } else if (propertyData instanceof PropertyDateTime) {
            values = JcrConverter.toValue((PropertyDateTime)propertyData, node.getSession().getValueFactory());
            propertyType = 5;
        } else if (propertyData instanceof PropertyDecimal) {
            values = JcrConverter.toValue((PropertyDecimal)propertyData, node.getSession().getValueFactory());
            propertyType = 12;
        } else if (propertyData instanceof PropertyHtml) {
            values = JcrConverter.toValue((PropertyHtml)propertyData, node.getSession().getValueFactory());
            propertyType = 1;
        } else if (propertyData instanceof PropertyId) {
            values = JcrConverter.toValue((PropertyId)propertyData, node.getSession().getValueFactory());
            propertyType = 1;
        } else if (propertyData instanceof PropertyInteger) {
            values = JcrConverter.toValue((PropertyInteger)propertyData, node.getSession().getValueFactory());
            propertyType = 12;
        } else if (propertyData instanceof PropertyString) {
            values = JcrConverter.toValue((PropertyString)propertyData, node.getSession().getValueFactory());
            propertyType = 1;
        } else if (propertyData instanceof PropertyUri) {
            values = JcrConverter.toValue((PropertyUri)propertyData, node.getSession().getValueFactory());
            propertyType = 11;
        } else {
            throw new CmisInvalidArgumentException("Invalid property type: " + propertyData);
        }
        String id = propertyData.getId();
        if ("cmis:name".equals(id)) {
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}title");
            name = "{http://www.jcp.org/jcr/1.0}title";
        } else {
            name = "cmis:contentStreamMimeType".equals(id) ? "{http://www.jcp.org/jcr/1.0}mimeType" : JcrConverter.toJcrName(propertyData.getId());
        }
        if (values.length == 1) {
            node.setProperty(name, values[0]);
        } else {
            node.setProperty(name, values, propertyType);
        }
    }

    public static void removeProperty(Node node, PropertyData<?> propertyData) throws RepositoryException {
        String name;
        String id = propertyData.getId();
        String string = name = "cmis:name".equals(id) ? "{http://www.jcp.org/jcr/1.0}title" : JcrConverter.toJcrName(propertyData.getId());
        if (node.hasProperty(name)) {
            node.getProperty(name).remove();
        }
    }

    private static List<String> toStrings(Value[] values) throws RepositoryException {
        ArrayList<String> strings = new ArrayList<String>(values.length);
        for (Value v : values) {
            strings.add(v.getString());
        }
        return strings;
    }

    private static List<BigInteger> toInts(Value[] values) throws RepositoryException {
        ArrayList<BigInteger> ints = new ArrayList<BigInteger>(values.length);
        for (Value v : values) {
            ints.add(BigInteger.valueOf(v.getLong()));
        }
        return ints;
    }

    private static List<BigDecimal> toDecs(Value[] values) throws RepositoryException {
        ArrayList<BigDecimal> decs = new ArrayList<BigDecimal>(values.length);
        for (Value v : values) {
            decs.add(v.getDecimal());
        }
        return decs;
    }

    private static List<BigDecimal> doublesToDecs(Value[] values) throws RepositoryException {
        ArrayList<BigDecimal> decs = new ArrayList<BigDecimal>(values.length);
        for (Value v : values) {
            decs.add(BigDecimal.valueOf(v.getDouble()));
        }
        return decs;
    }

    private static List<Boolean> toBools(Value[] values) throws RepositoryException {
        ArrayList<Boolean> bools = new ArrayList<Boolean>(values.length);
        for (Value v : values) {
            bools.add(v.getBoolean());
        }
        return bools;
    }

    private static List<GregorianCalendar> toDates(Value[] values) throws RepositoryException {
        ArrayList<GregorianCalendar> dates = new ArrayList<GregorianCalendar>(values.length);
        for (Value v : values) {
            dates.add(Util.toCalendar(v.getDate()));
        }
        return dates;
    }

    private static Value[] toValue(PropertyBoolean propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (Boolean v : values) {
            result[k++] = valueFactory.createValue(v.booleanValue());
        }
        return result;
    }

    private static Value[] toValue(PropertyDateTime propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (GregorianCalendar v : values) {
            result[k++] = valueFactory.createValue((Calendar)v);
        }
        return result;
    }

    private static Value[] toValue(PropertyDecimal propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (BigDecimal v : values) {
            result[k++] = valueFactory.createValue(v);
        }
        return result;
    }

    private static Value[] toValue(PropertyHtml propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (String v : values) {
            result[k++] = valueFactory.createValue(v);
        }
        return result;
    }

    private static Value[] toValue(PropertyId propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (String v : values) {
            result[k++] = valueFactory.createValue(v);
        }
        return result;
    }

    private static Value[] toValue(PropertyInteger propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (BigInteger v : values) {
            result[k++] = valueFactory.createValue(new BigDecimal(v));
        }
        return result;
    }

    private static Value[] toValue(PropertyString propertyData, ValueFactory valueFactory) {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (String v : values) {
            result[k++] = valueFactory.createValue(v);
        }
        return result;
    }

    private static Value[] toValue(PropertyUri propertyData, ValueFactory valueFactory) throws ValueFormatException {
        List values = propertyData.getValues();
        if (values == null) {
            return new Value[0];
        }
        Value[] result = new Value[values.size()];
        int k = 0;
        for (String v : values) {
            result[k++] = valueFactory.createValue(v, 11);
        }
        return result;
    }
}

