/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.jcr.JcrRepository;
import org.apache.chemistry.opencmis.jcr.JcrService;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.impl.DefaultDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultFolderTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultUnversionedDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrServiceFactory
extends AbstractServiceFactory {
    private static final Log log = LogFactory.getLog(JcrServiceFactory.class);
    public static final String MOUNT_PATH_CONFIG = "mount-path";
    public static final String PREFIX_JCR_CONFIG = "jcr.";
    public static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(50L);
    public static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    public static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(200L);
    public static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(10L);
    private JcrTypeManager typeManager;
    private Map<String, String> jcrConfig;
    private String mountPath;
    private JcrRepository jcrRepository;

    public void init(Map<String, String> parameters) {
        this.typeManager = this.createTypeManager();
        this.readConfiguration(parameters);
        PathManager pathManger = new PathManager(this.mountPath);
        JcrTypeHandlerManager typeHandlerManager = this.createTypeHandlerManager(pathManger, this.typeManager);
        this.jcrRepository = new JcrRepository(this.acquireJcrRepository(this.jcrConfig), pathManger, this.typeManager, typeHandlerManager);
    }

    public void destroy() {
        this.jcrRepository = null;
        this.typeManager = null;
    }

    public CmisService getService(CallContext context) {
        CmisServiceWrapper serviceWrapper = new CmisServiceWrapper((CmisService)this.createJcrService(this.jcrRepository, context), DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
        ((JcrService)serviceWrapper.getWrappedService()).setCallContext(context);
        return serviceWrapper;
    }

    protected Repository acquireJcrRepository(Map<String, String> jcrConfig) {
        try {
            Iterator<RepositoryFactory> factories = ServiceRegistry.lookupProviders(RepositoryFactory.class);
            while (factories.hasNext()) {
                RepositoryFactory factory = factories.next();
                log.debug((Object)("Trying to acquire JCR repository from factory " + factory));
                Repository repository = factory.getRepository(jcrConfig);
                if (repository != null) {
                    log.debug((Object)("Successfully acquired JCR repository from factory " + factory));
                    return repository;
                }
                log.debug((Object)("Could not acquire JCR repository from factory " + factory));
            }
            throw new CmisConnectionException("No JCR repository factory for configured parameters");
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    protected JcrService createJcrService(JcrRepository jcrRepository, CallContext context) {
        return new JcrService(jcrRepository);
    }

    protected JcrTypeManager createTypeManager() {
        return new JcrTypeManager();
    }

    protected JcrTypeHandlerManager createTypeHandlerManager(PathManager pathManager, JcrTypeManager typeManager) {
        JcrTypeHandlerManager typeHandlerManager = new JcrTypeHandlerManager(pathManager, typeManager);
        typeHandlerManager.addHandler(new DefaultFolderTypeHandler());
        typeHandlerManager.addHandler(new DefaultDocumentTypeHandler());
        typeHandlerManager.addHandler(new DefaultUnversionedDocumentTypeHandler());
        return typeHandlerManager;
    }

    private void readConfiguration(Map<String, String> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            if (key.startsWith(PREFIX_JCR_CONFIG)) {
                String jcrKey = key.substring(PREFIX_JCR_CONFIG.length());
                String jcrValue = JcrServiceFactory.replaceSystemProperties(parameters.get(key));
                map.put(jcrKey, jcrValue);
                continue;
            }
            if (MOUNT_PATH_CONFIG.equals(key)) {
                this.mountPath = parameters.get(key);
                log.debug((Object)("Configuration: mount-path=" + this.mountPath));
                continue;
            }
            log.warn((Object)("Configuration: unrecognized key: " + key));
        }
        this.jcrConfig = Collections.unmodifiableMap(map);
        log.debug((Object)("Configuration: jcr=" + this.jcrConfig));
    }

    private static String replaceSystemProperties(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder property = null;
        boolean inProperty = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inProperty) {
                if (c == '}') {
                    String value = System.getProperty(property.toString());
                    if (value != null) {
                        result.append(value);
                    }
                    inProperty = false;
                    continue;
                }
                property.append(c);
                continue;
            }
            if (c == '{') {
                property = new StringBuilder();
                inProperty = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

