/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.jcr.JcrBinary;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrFolder;
import org.apache.chemistry.opencmis.jcr.JcrNode;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersion;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.impl.AbstractJcrTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultDocumentIdentifierMap;
import org.apache.chemistry.opencmis.jcr.query.IdentifierMap;
import org.apache.chemistry.opencmis.jcr.type.JcrDocumentTypeHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultDocumentTypeHandler
extends AbstractJcrTypeHandler
implements JcrDocumentTypeHandler {
    private static final Log log = LogFactory.getLog(JcrFolder.class);

    public String getTypeId() {
        return BaseTypeId.CMIS_DOCUMENT.value();
    }

    public TypeDefinition getTypeDefinition() {
        DocumentTypeDefinitionImpl documentType = new DocumentTypeDefinitionImpl();
        documentType.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        documentType.setIsControllableAcl(Boolean.valueOf(false));
        documentType.setIsControllablePolicy(Boolean.valueOf(false));
        documentType.setIsCreatable(Boolean.valueOf(true));
        documentType.setDescription("Document");
        documentType.setDisplayName("Document");
        documentType.setIsFileable(Boolean.valueOf(true));
        documentType.setIsFulltextIndexed(Boolean.valueOf(false));
        documentType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        documentType.setLocalName("Document");
        documentType.setLocalNamespace("http://opencmis.org/jcr");
        documentType.setIsQueryable(Boolean.valueOf(true));
        documentType.setQueryName("cmis:document");
        documentType.setId("cmis:document");
        documentType.setIsVersionable(Boolean.valueOf(true));
        documentType.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        JcrTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)documentType);
        JcrTypeManager.addDocumentPropertyDefinitions(documentType);
        return documentType;
    }

    public IdentifierMap getIdentifierMap() {
        return new DefaultDocumentIdentifierMap(true);
    }

    public JcrDocument getJcrNode(Node node) throws RepositoryException {
        VersionManager versionManager = node.getSession().getWorkspace().getVersionManager();
        Version version = versionManager.getBaseVersion(node.getPath());
        return new JcrVersion(node, version, this.typeManager, this.pathManager, this.typeHandlerManager);
    }

    public boolean canHandle(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") && node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrNode createDocument(JcrFolder parentFolder, String name, Properties properties, ContentStream contentStream, VersioningState versioningState) {
        try {
            Node fileNode = parentFolder.getNode().addNode(name, "{http://www.jcp.org/jcr/nt/1.0}file");
            if (versioningState != VersioningState.NONE) {
                fileNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
            }
            Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
            contentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}created");
            JcrFolder.setProperties(contentNode, this.getTypeDefinition(), properties);
            Binary binary = contentStream == null || contentStream.getStream() == null ? JcrBinary.EMPTY : new JcrBinary(new BufferedInputStream(contentStream.getStream()));
            try {
                contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
                if (contentStream != null && contentStream.getMimeType() != null) {
                    contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", contentStream.getMimeType());
                }
            }
            finally {
                binary.dispose();
            }
            fileNode.getSession().save();
            JcrDocument jcrFileNode = this.getJcrNode(fileNode);
            if (versioningState == VersioningState.NONE) {
                return jcrFileNode;
            }
            JcrVersionBase jcrVersion = jcrFileNode.asVersion();
            if (versioningState == VersioningState.MINOR || versioningState == VersioningState.MAJOR) {
                return jcrVersion.checkin(null, null, "auto checkin");
            }
            return jcrVersion.getPwc();
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }
}

