/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.affinity;

import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.infinispan.Cache;
import org.infinispan.affinity.BaseKeyAffinityServiceTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;

public abstract class BaseFilterKeyAffinityServiceTest
extends BaseKeyAffinityServiceTest {
    private static final Log log = LogFactory.getLog(BaseFilterKeyAffinityServiceTest.class);
    protected EmbeddedCacheManager cacheManager;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.INIT_CLUSTER_SIZE = 2;
        super.createCacheManagers();
        this.createService();
    }

    protected abstract void createService();

    protected abstract List<Address> getAddresses();

    protected void testSingleKey() throws InterruptedException {
        Map blockingQueueMap = this.keyAffinityService.getAddress2KeysMapping();
        AssertJUnit.assertEquals((int)this.getAddresses().size(), (int)blockingQueueMap.keySet().size());
        this.assertEventualFullCapacity(this.getAddresses());
    }

    protected void testAddNewServer() throws Exception {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration(this.cacheName, this.configuration);
        Cache cache = cm.getCache(this.cacheName);
        this.caches.add(cache);
        this.waitForClusterToResize();
        this.assertUnaffected();
    }

    protected void testRemoveServers() throws InterruptedException {
        log.info((Object)"** before calling stop");
        ((Cache)this.caches.get(2)).getCacheManager().stop();
        this.caches.remove(2);
        this.waitForClusterToResize();
        Assert.assertEquals((int)2, (int)this.caches.size());
        this.assertUnaffected();
    }

    protected void testShutdownOwnManager() {
        log.info((Object)"**** here it starts");
        ((Cache)this.caches.get(0)).getCacheManager().stop();
        this.caches.remove(0);
        Assert.assertEquals((int)1, (int)this.caches.size());
        TestingUtil.blockUntilViewsReceived(10000L, false, this.caches.toArray(new Cache[0]));
        Assert.assertEquals((int)1, (int)this.topology().size());
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !BaseFilterKeyAffinityServiceTest.this.keyAffinityService.isStarted();
            }
        });
    }

    private void assertUnaffected() throws InterruptedException {
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BaseFilterKeyAffinityServiceTest.this.keyAffinityService.getAddress2KeysMapping().keySet().size() == BaseFilterKeyAffinityServiceTest.this.getAddresses().size();
            }
        });
        this.assertEventualFullCapacity(this.getAddresses());
        this.assertKeyAffinityCorrectness(this.getAddresses());
    }
}

