/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.MixedModeTest")
public class MixedModeTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration replSync = MixedModeTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        Configuration replAsync = MixedModeTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC);
        Configuration invalSync = MixedModeTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_SYNC);
        Configuration invalAsync = MixedModeTest.getDefaultClusteredConfig(Configuration.CacheMode.INVALIDATION_ASYNC);
        Configuration local = MixedModeTest.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL);
        this.createClusteredCaches(2, "replSync", replSync);
        this.defineConfigurationOnAllManagers("replAsync", replAsync);
        this.defineConfigurationOnAllManagers("invalSync", invalSync);
        this.defineConfigurationOnAllManagers("invalAsync", invalAsync);
        this.defineConfigurationOnAllManagers("local", local);
    }

    public void testMixedMode() {
        AdvancedCache replSyncCache1 = this.cache(0, "replSync").getAdvancedCache();
        AdvancedCache replSyncCache2 = this.cache(1, "replSync").getAdvancedCache();
        AdvancedCache replAsyncCache1 = this.cache(0, "replAsync").getAdvancedCache();
        AdvancedCache replAsyncCache2 = this.cache(1, "replAsync").getAdvancedCache();
        AdvancedCache invalSyncCache1 = this.cache(0, "invalSync").getAdvancedCache();
        AdvancedCache invalSyncCache2 = this.cache(1, "invalSync").getAdvancedCache();
        AdvancedCache invalAsyncCache1 = this.cache(0, "invalAsync").getAdvancedCache();
        AdvancedCache invalAsyncCache2 = this.cache(1, "invalAsync").getAdvancedCache();
        AdvancedCache localCache1 = this.cache(0, "local").getAdvancedCache();
        AdvancedCache localCache2 = this.cache(1, "local").getAdvancedCache();
        invalSyncCache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"k", (Object)"v");
        assert (invalSyncCache2.get((Object)"k").equals("v"));
        assert (invalSyncCache1.get((Object)"k") == null);
        invalAsyncCache2.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).put((Object)"k", (Object)"v");
        assert (invalAsyncCache2.get((Object)"k").equals("v"));
        assert (invalAsyncCache1.get((Object)"k") == null);
        this.replListener((Cache)replAsyncCache2).expectAny();
        this.replListener((Cache)invalAsyncCache2).expectAny();
        replSyncCache1.put((Object)"k", (Object)"replSync");
        replAsyncCache1.put((Object)"k", (Object)"replAsync");
        invalSyncCache1.put((Object)"k", (Object)"invalSync");
        invalAsyncCache1.put((Object)"k", (Object)"invalAsync");
        localCache1.put((Object)"k", (Object)"local");
        this.replListener((Cache)replAsyncCache2).waitForRpc();
        this.replListener((Cache)invalAsyncCache2).waitForRpc();
        assert (replSyncCache1.get((Object)"k").equals("replSync"));
        assert (replSyncCache2.get((Object)"k").equals("replSync"));
        assert (replAsyncCache1.get((Object)"k").equals("replAsync"));
        assert (replAsyncCache2.get((Object)"k").equals("replAsync"));
        assert (invalSyncCache1.get((Object)"k").equals("invalSync"));
        assert (invalSyncCache2.get((Object)"k") == null);
        assert (invalAsyncCache1.get((Object)"k").equals("invalAsync"));
        assert (invalAsyncCache2.get((Object)"k") == null);
        assert (localCache1.get((Object)"k").equals("local"));
        assert (localCache2.get((Object)"k") == null);
    }
}

