/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicHashMapDelta;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.NullDelta;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="atomic.AtomicHashMapTest")
public class AtomicHashMapTest
extends AbstractInfinispanTest {
    public void testDeltasWithEmptyMap() {
        AtomicHashMap m = new AtomicHashMap();
        Delta d = m.delta();
        assert (d instanceof NullDelta);
        AtomicHashMap newMap = new AtomicHashMap();
        newMap.initForWriting();
        newMap.put((Object)"k", (Object)"v");
        newMap = (AtomicHashMap)d.merge((DeltaAware)newMap);
        assert (newMap.containsKey((Object)"k"));
        assert (newMap.size() == 1);
        newMap = (AtomicHashMap)d.merge(null);
        assert (newMap.isEmpty());
    }

    public void testDeltasWithNoChanges() {
        AtomicHashMap m = new AtomicHashMap();
        m.initForWriting();
        m.put((Object)"k1", (Object)"v1");
        m.commit();
        assert (m.size() == 1);
        Delta d = m.delta();
        assert (d instanceof NullDelta);
        AtomicHashMap newMap = new AtomicHashMap();
        newMap.initForWriting();
        newMap.put((Object)"k", (Object)"v");
        newMap = (AtomicHashMap)d.merge((DeltaAware)newMap);
        assert (newMap.containsKey((Object)"k"));
        assert (newMap.size() == 1);
        newMap = (AtomicHashMap)d.merge(null);
        assert (newMap.isEmpty());
    }

    public void testDeltasWithRepeatedChanges() {
        AtomicHashMap m = new AtomicHashMap();
        m.initForWriting();
        m.put((Object)"k1", (Object)"v1");
        m.put((Object)"k1", (Object)"v2");
        m.put((Object)"k1", (Object)"v3");
        assert (m.size() == 1);
        AtomicHashMapDelta d = (AtomicHashMapDelta)m.delta();
        assert (d.getChangeLogSize() != 0);
        AtomicHashMap newMap = new AtomicHashMap();
        newMap.initForWriting();
        newMap.put((Object)"k1", (Object)"v4");
        newMap = (AtomicHashMap)d.merge((DeltaAware)newMap);
        assert (newMap.containsKey((Object)"k1"));
        assert (newMap.get((Object)"k1").equals("v3"));
        assert (newMap.size() == 1);
        newMap = (AtomicHashMap)d.merge(null);
        assert (newMap.containsKey((Object)"k1"));
        assert (newMap.get((Object)"k1").equals("v3"));
        assert (newMap.size() == 1);
    }
}

