/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.lang.reflect.Method;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMapTestAssertions;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.ClusteredAPITest")
public class ClusteredAPITest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = ClusteredAPITest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        c.setInvocationBatchingEnabled(true);
        this.createClusteredCaches(2, "atomic", c);
    }

    public void testReplicationCommit() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        AtomicMap map = AtomicMapLookup.getAtomicMap(cache1, (Object)"map");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 2);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").size() == 2);
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").get((Object)"blah").equals("blah"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").containsKey((Object)"blah"));
    }

    public void testMultipleReplicationCommit(Method m) throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        AtomicMap map = AtomicMapLookup.getAtomicMap(cache1, (Object)"map");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 2);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        assert (((String)map.get((Object)"existing")).equals("existing"));
        assert (map.containsKey((Object)"existing"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").size() == 2);
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").get((Object)"blah").equals("blah"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").containsKey((Object)"blah"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").get((Object)"existing").equals("existing"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").containsKey((Object)"existing"));
        map = AtomicMapLookup.getAtomicMap(cache1, (Object)"map");
        TestingUtil.getTransactionManager(cache1).begin();
        String newKey = "k-" + m.getName();
        String newValue = "v-" + m.getName();
        map.put((Object)newKey, (Object)newValue);
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 3);
        assert (((String)map.get((Object)"blah")).equals("blah"));
        assert (map.containsKey((Object)"blah"));
        assert (((String)map.get((Object)"existing")).equals("existing"));
        assert (map.containsKey((Object)"existing"));
        assert (((String)map.get((Object)newKey)).equals(newValue));
        assert (map.containsKey((Object)newKey));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").size() == 3);
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").get((Object)"blah").equals("blah"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").containsKey((Object)"blah"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").get((Object)"existing").equals("existing"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").containsKey((Object)"existing"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").get((Object)newKey).equals(newValue));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)"map").containsKey((Object)newKey));
    }

    public void testReplicationCommitCreateMapInTransaction(Method m) throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        TestingUtil.getTransactionManager(cache1).begin();
        AtomicMap map = AtomicMapLookup.getAtomicMap(cache1, (Object)m.getName());
        map.put((Object)"a", (Object)"b");
        TestingUtil.getTransactionManager(cache1).commit();
        assert (map.size() == 1);
        assert (((String)map.get((Object)"a")).equals("b"));
        assert (map.containsKey((Object)"a"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)m.getName()).size() == 1);
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)m.getName()).get((Object)"a").equals("b"));
        assert (AtomicMapLookup.getAtomicMap(cache2, (Object)m.getName()).containsKey((Object)"a"));
    }

    public void testReplicationRollback() throws Exception {
        Cache cache1 = this.cache(0, "atomic");
        Cache cache2 = this.cache(1, "atomic");
        AtomicHashMapTestAssertions.assertIsEmptyMap(cache2, "map");
        AtomicMap map = AtomicMapLookup.getAtomicMap(cache1, (Object)"map");
        TestingUtil.getTransactionManager(cache1).begin();
        map.put((Object)"existing", (Object)"existing");
        map.put((Object)"blah", (Object)"blah");
        TestingUtil.getTransactionManager(cache1).rollback();
        AtomicHashMapTestAssertions.assertIsEmpty((Map)map);
        AtomicHashMapTestAssertions.assertIsEmptyMap(cache1, "map");
        AtomicHashMapTestAssertions.assertIsEmptyMap(cache2, "map");
    }
}

