/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.SampleConfigFilesCorrectnessTest")
public class SampleConfigFilesCorrectnessTest {
    public static final String CONFIG_ROOT = "src/main/resources/config-samples";
    private static final Log log = LogFactory.getLog(SampleConfigFilesCorrectnessTest.class);
    private InMemoryAppender appender;
    private Level oldLevel;

    @BeforeMethod
    public void setUpTest() {
        Logger log4jLogger = Logger.getRootLogger();
        this.oldLevel = log4jLogger.getLevel();
        log4jLogger.setLevel(Level.WARN);
        this.appender = new InMemoryAppender();
        log4jLogger.addAppender((Appender)this.appender);
    }

    @AfterMethod
    public void tearDownTest() {
        Logger log4jLogger = Logger.getRootLogger();
        log4jLogger.setLevel(this.oldLevel);
        log4jLogger.removeAppender((Appender)this.appender);
        this.appender.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigWarnings() throws Exception {
        for (String aConfFile : this.getConfigFileNames()) {
            log.tracef("Analysing %s", (Object)aConfFile);
            EmbeddedCacheManager dcm = TestCacheManagerFactory.fromXml(this.getRootFolder() + "/" + aConfFile);
            try {
                dcm.getCache();
                assert (!this.appender.isFoundUnknownWarning()) : String.format("Unknown warning discovered in file %s: %s", aConfFile, this.appender.unknownWarning());
                for (String cacheName : dcm.getCacheNames()) {
                    dcm.getCache(cacheName);
                    assert (!this.appender.isFoundUnknownWarning());
                }
            }
            catch (Throwable throwable) {
                TestingUtil.killCacheManagers(dcm);
                throw throwable;
            }
            TestingUtil.killCacheManagers(dcm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWarningForMissingQuery() {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.createCacheManager(Configuration.CacheMode.LOCAL, true);
        try {
            embeddedCacheManager.getCache();
            assert (this.appender.isFoundUnknownWarning());
            assert (this.appender.unknownWarning().contains("infinispan-query.jar"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(embeddedCacheManager);
            throw throwable;
        }
        TestingUtil.killCacheManagers(embeddedCacheManager);
    }

    private String[] getConfigFileNames() {
        File file = this.getRootFolder();
        if (!file.isDirectory()) {
            log.tracef("file.getAbsolutePath() = %s", new Object[0]);
        }
        return file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && !name.startsWith("jgroups") && !name.contains("ec2");
            }
        });
    }

    private File getRootFolder() {
        File file = new File(CONFIG_ROOT);
        if (!file.isDirectory()) {
            file = new File("core/src/main/resources/config-samples");
        }
        return file;
    }

    private static class InMemoryAppender
    extends AppenderSkeleton {
        String[] TOLERABLE_WARNINGS = new String[]{"Falling back to DummyTransactionManager from Infinispan", "Please set your max receive buffer in the OS correctly", "receive buffer of socket java.net.MulticastSocket@", "Property ec2.access_key could not be replaced as intended", "Property ec2.access_secret could not be replaced as intended", "Property ec2.bucket could not be replaced as intended", "S3_PING could not be substituted", "This might lead to performance problems. Please set your", "stateRetrieval's 'alwaysProvideInMemoryState' attribute is no longer in use"};
        String unknownWarning;
        private Thread loggerThread = Thread.currentThread();

        private InMemoryAppender() {
        }

        protected void append(LoggingEvent event) {
            if (event.getLevel().equals((Object)Level.WARN) && this.isExpectedThread()) {
                boolean skipPrinting = false;
                for (String knownWarn : this.TOLERABLE_WARNINGS) {
                    if (event.getMessage().toString().indexOf(knownWarn) < 0) continue;
                    skipPrinting = true;
                }
                if (!skipPrinting) {
                    this.unknownWarning = event.getMessage().toString();
                    log.tracef("InMemoryAppender: %s", (Object)event.getMessage().toString());
                    log.tracef("TOLERABLE_WARNINGS: %s", (Object)Arrays.toString(this.TOLERABLE_WARNINGS));
                }
            }
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        public boolean isFoundUnknownWarning() {
            return this.unknownWarning != null;
        }

        public String unknownWarning() {
            return this.unknownWarning;
        }

        public boolean isExpectedThread() {
            return this.loggerThread.equals(Thread.currentThread());
        }
    }
}

