/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.HashSet;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.Immutables;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="container.SimpleDataContainerTest")
public class SimpleDataContainerTest
extends AbstractInfinispanTest {
    DataContainer dc;

    @BeforeMethod
    public void setUp() {
        this.dc = this.createContainer();
    }

    @AfterMethod
    public void tearDown() {
        this.dc = null;
    }

    protected DataContainer createContainer() {
        DefaultDataContainer dc = new DefaultDataContainer(16);
        dc.initialize(null, null, (InternalEntryFactory)new InternalEntryFactoryImpl());
        return dc;
    }

    public void testExpiredData() throws InterruptedException {
        this.dc.put((Object)"k", (Object)"v", null, -1L, 6000000L);
        Thread.sleep(100L);
        InternalCacheEntry entry = this.dc.get((Object)"k");
        assert (entry.getClass().equals(this.transienttype()));
        assert (entry.getLastUsed() <= System.currentTimeMillis());
        long entryLastUsed = entry.getLastUsed();
        Thread.sleep(100L);
        entry = this.dc.get((Object)"k");
        assert (entry.getLastUsed() > entryLastUsed);
        this.dc.put((Object)"k", (Object)"v", null, -1L, 0L);
        this.dc.purgeExpired();
        this.dc.put((Object)"k", (Object)"v", null, 6000000L, -1L);
        Thread.sleep(100L);
        assert (this.dc.size() == 1);
        entry = this.dc.get((Object)"k");
        assert (entry != null) : "Entry should not be null!";
        assert (entry.getClass().equals(this.mortaltype())) : "Expected " + this.mortaltype() + ", was " + entry.getClass().getSimpleName();
        assert (entry.getCreated() <= System.currentTimeMillis());
        this.dc.put((Object)"k", (Object)"v", null, 0L, -1L);
        Thread.sleep(10L);
        assert (this.dc.get((Object)"k") == null);
        assert (this.dc.size() == 0);
        this.dc.put((Object)"k", (Object)"v", null, 0L, -1L);
        Thread.sleep(100L);
        assert (this.dc.size() == 1);
        this.dc.purgeExpired();
        assert (this.dc.size() == 0);
    }

    public void testResetOfCreationTime() throws Exception {
        long now = System.currentTimeMillis();
        this.dc.put((Object)"k", (Object)"v", null, 1000000L, -1L);
        long created1 = this.dc.get((Object)"k").getCreated();
        assert (created1 >= now);
        Thread.sleep(100L);
        this.dc.put((Object)"k", (Object)"v", null, 1000000L, -1L);
        long created2 = this.dc.get((Object)"k").getCreated();
        assert (created2 > created1) : "Expected " + created2 + " to be greater than " + created1;
    }

    public void testUpdatingLastUsed() throws Exception {
        long idle = 600000L;
        this.dc.put((Object)"k", (Object)"v", null, -1L, -1L);
        InternalCacheEntry ice = this.dc.get((Object)"k");
        assert (ice.getClass().equals(this.immortaltype()));
        assert (ice.getExpiryTime() == -1L);
        assert (ice.getMaxIdle() == -1L);
        assert (ice.getLifespan() == -1L);
        this.dc.put((Object)"k", (Object)"v", null, -1L, idle);
        long oldTime = System.currentTimeMillis();
        Thread.sleep(100L);
        ice = this.dc.get((Object)"k");
        assert (ice.getClass().equals(this.transienttype()));
        assert (ice.getExpiryTime() > -1L);
        assert (ice.getLastUsed() > oldTime);
        Thread.sleep(100L);
        assert (ice.getLastUsed() < System.currentTimeMillis());
        assert (ice.getMaxIdle() == idle);
        assert (ice.getLifespan() == -1L);
        oldTime = System.currentTimeMillis();
        Thread.sleep(100L);
        assert (this.dc.get((Object)"k") != null);
        assert (ice.getLastUsed() > oldTime);
        Thread.sleep(100L);
        assert (ice.getLastUsed() < System.currentTimeMillis());
    }

    protected Class<? extends InternalCacheEntry> mortaltype() {
        return MortalCacheEntry.class;
    }

    protected Class<? extends InternalCacheEntry> immortaltype() {
        return ImmortalCacheEntry.class;
    }

    protected Class<? extends InternalCacheEntry> transienttype() {
        return TransientCacheEntry.class;
    }

    protected Class<? extends InternalCacheEntry> transientmortaltype() {
        return TransientMortalCacheEntry.class;
    }

    public void testExpirableToImmortalAndBack() {
        String value = "v";
        this.dc.put((Object)"k", (Object)value, null, 6000000L, -1L);
        this.assertContainerEntry(this.mortaltype(), value);
        value = "v2";
        this.dc.put((Object)"k", (Object)value, null, -1L, -1L);
        this.assertContainerEntry(this.immortaltype(), value);
        value = "v3";
        this.dc.put((Object)"k", (Object)value, null, -1L, 6000000L);
        this.assertContainerEntry(this.transienttype(), value);
        value = "v4";
        this.dc.put((Object)"k", (Object)value, null, 6000000L, 6000000L);
        this.assertContainerEntry(this.transientmortaltype(), value);
        value = "v41";
        this.dc.put((Object)"k", (Object)value, null, 6000000L, 6000000L);
        this.assertContainerEntry(this.transientmortaltype(), value);
        value = "v5";
        this.dc.put((Object)"k", (Object)value, null, 6000000L, -1L);
        this.assertContainerEntry(this.mortaltype(), value);
    }

    private void assertContainerEntry(Class<? extends InternalCacheEntry> type, String expectedValue) {
        assert (this.dc.containsKey((Object)"k"));
        InternalCacheEntry entry = this.dc.get((Object)"k");
        AssertJUnit.assertEquals(type, entry.getClass());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)entry.getValue());
    }

    public void testKeySet() {
        this.dc.put((Object)"k1", (Object)"v", null, 6000000L, -1L);
        this.dc.put((Object)"k2", (Object)"v", null, -1L, -1L);
        this.dc.put((Object)"k3", (Object)"v", null, -1L, 6000000L);
        this.dc.put((Object)"k4", (Object)"v", null, 6000000L, 6000000L);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (Object o : this.dc.keySet()) {
            assert (expected.remove(o));
        }
        assert (expected.isEmpty()) : "Did not see keys " + expected + " in iterator!";
    }

    public void testContainerIteration() {
        this.dc.put((Object)"k1", (Object)"v", null, 6000000L, -1L);
        this.dc.put((Object)"k2", (Object)"v", null, -1L, -1L);
        this.dc.put((Object)"k3", (Object)"v", null, -1L, 6000000L);
        this.dc.put((Object)"k4", (Object)"v", null, 6000000L, 6000000L);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (InternalCacheEntry ice : this.dc) {
            assert (expected.remove(ice.getKey()));
        }
        assert (expected.isEmpty()) : "Did not see keys " + expected + " in iterator!";
    }

    public void testKeys() {
        this.dc.put((Object)"k1", (Object)"v1", null, 6000000L, -1L);
        this.dc.put((Object)"k2", (Object)"v2", null, -1L, -1L);
        this.dc.put((Object)"k3", (Object)"v3", null, -1L, 6000000L);
        this.dc.put((Object)"k4", (Object)"v4", null, 6000000L, 6000000L);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (Object o : this.dc.keySet()) {
            assert (expected.remove(o));
        }
        assert (expected.isEmpty()) : "Did not see keys " + expected + " in iterator!";
    }

    public void testValues() {
        this.dc.put((Object)"k1", (Object)"v1", null, 6000000L, -1L);
        this.dc.put((Object)"k2", (Object)"v2", null, -1L, -1L);
        this.dc.put((Object)"k3", (Object)"v3", null, -1L, 6000000L);
        this.dc.put((Object)"k4", (Object)"v4", null, 6000000L, 6000000L);
        HashSet<String> expected = new HashSet<String>();
        expected.add("v1");
        expected.add("v2");
        expected.add("v3");
        expected.add("v4");
        for (Object o : this.dc.values()) {
            assert (expected.remove(o));
        }
        assert (expected.isEmpty()) : "Did not see keys " + expected + " in iterator!";
    }

    public void testEntrySet() {
        this.dc.put((Object)"k1", (Object)"v1", null, 6000000L, -1L);
        this.dc.put((Object)"k2", (Object)"v2", null, -1L, -1L);
        this.dc.put((Object)"k3", (Object)"v3", null, -1L, 6000000L);
        this.dc.put((Object)"k4", (Object)"v4", null, 6000000L, 6000000L);
        HashSet<InternalCacheEntry> expected = new HashSet<InternalCacheEntry>();
        expected.add(Immutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k1")));
        expected.add(Immutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k2")));
        expected.add(Immutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k3")));
        expected.add(Immutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k4")));
        HashSet<InternalCacheEntry> actual = new HashSet<InternalCacheEntry>();
        for (InternalCacheEntry o : this.dc.entrySet()) {
            actual.add(o);
        }
        assert (((Object)actual).equals(expected)) : "Expected to see keys " + expected + " but only saw " + actual;
    }

    public void testGetDuringKeySetLoop() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.dc.put((Object)i, (Object)"value", null, -1L, -1L);
        }
        i = 0;
        for (Object key : this.dc.keySet()) {
            this.dc.peek(key);
            ++i;
        }
        assert (i == 10) : "Expected the loop to run 10 times, only ran " + i;
    }
}

