/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="context.SingleKeyNonTxInvocationContextTest")
public class SingleKeyNonTxInvocationContextTest
extends MultipleCacheManagersTest {
    private CheckInterceptor ci0;
    private CheckInterceptor ci1;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = SingleKeyNonTxInvocationContextTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, false);
        c.fluent().hash().numOwners(Integer.valueOf(1));
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.ci0 = new CheckInterceptor();
        this.advancedCache(0).addInterceptor((CommandInterceptor)this.ci0, 1);
        this.ci1 = new CheckInterceptor();
        this.advancedCache(1).addInterceptor((CommandInterceptor)this.ci1, 1);
    }

    public void testPut() {
        assert (!this.ci0.putOkay && !this.ci1.putOkay);
        this.cache(0).put(this.getKeyForCache(0), (Object)"v");
        assert (this.ci0.putOkay && !this.ci1.putOkay);
        this.cache(1).put(this.getKeyForCache(1), (Object)"v");
        assert (this.ci0.putOkay && this.ci1.putOkay);
    }

    public void testRemove() {
        assert (!this.ci0.removeOkay && !this.ci1.removeOkay);
        this.cache(0).remove(this.getKeyForCache(0));
        assert (this.ci0.removeOkay && !this.ci1.removeOkay);
        this.cache(1).remove(this.getKeyForCache(1));
        assert (this.ci0.removeOkay && this.ci1.removeOkay);
    }

    public void testGet() {
        assert (!this.ci0.getOkay && !this.ci1.getOkay);
        this.cache(0).get(this.getKeyForCache(0));
        assert (this.ci0.getOkay && !this.ci1.getOkay);
        this.cache(1).get(this.getKeyForCache(1));
        assert (this.ci0.getOkay && this.ci1.getOkay);
    }

    public void testReplace() {
        assert (!this.ci0.replaceOkay && !this.ci1.replaceOkay);
        this.cache(0).replace(this.getKeyForCache(0), (Object)"v");
        assert (this.ci0.replaceOkay && !this.ci1.replaceOkay);
        this.cache(1).replace(this.getKeyForCache(1), (Object)"v");
        assert (this.ci0.replaceOkay && this.ci1.replaceOkay);
    }

    static class CheckInterceptor
    extends CommandInterceptor {
        private boolean putOkay;
        private boolean removeOkay;
        private boolean getOkay;
        private boolean replaceOkay;

        CheckInterceptor() {
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.isRightType(ctx)) {
                this.putOkay = true;
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            if (this.isRightType(ctx)) {
                this.removeOkay = true;
            }
            return super.visitRemoveCommand(ctx, command);
        }

        public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
            if (this.isRightType(ctx)) {
                this.getOkay = true;
            }
            return super.visitGetKeyValueCommand(ctx, command);
        }

        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            if (this.isRightType(ctx)) {
                this.replaceOkay = true;
            }
            return super.visitReplaceCommand(ctx, command);
        }

        private boolean isRightType(InvocationContext ctx) {
            return ctx instanceof SingleKeyNonTxInvocationContext;
        }
    }
}

