/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collections;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.BaseDistCacheStoreTest;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistCacheStorePreloadTest")
public class DistCacheStorePreloadTest
extends BaseDistCacheStoreTest {
    public static final int NUM_KEYS = 10;

    public DistCacheStorePreloadTest() {
        this.INIT_CLUSTER_SIZE = 1;
        this.sync = true;
        this.tx = false;
        this.testRetVals = true;
        this.shared = true;
        this.preload = true;
    }

    @AfterMethod
    public void clearStats() {
        for (Cache c : this.caches) {
            System.out.println("Clearing stats for cache store on cache " + c);
            DummyInMemoryCacheStore cs = (DummyInMemoryCacheStore)TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            cs.clear();
            cs.clearStats();
        }
    }

    public void testPreloadOnStart() throws CacheLoaderException {
        for (int i = 0; i < 10; ++i) {
            this.c1.put((Object)("k" + i), (Object)("v" + i));
        }
        DataContainer dc1 = this.c1.getAdvancedCache().getDataContainer();
        assert (dc1.size() == 10);
        DummyInMemoryCacheStore cs = (DummyInMemoryCacheStore)TestingUtil.extractComponent(this.c1, CacheLoaderManager.class).getCacheStore();
        assert (cs.loadAllKeys(Collections.<Object>emptySet()).size() == 10);
        this.addClusterEnabledCacheManager();
        EmbeddedCacheManager cm2 = (EmbeddedCacheManager)this.cacheManagers.get(1);
        cm2.defineConfiguration(this.cacheName, this.buildConfiguration());
        this.c2 = this.cache(1, this.cacheName);
        this.waitForClusterToForm();
        DataContainer dc2 = this.c2.getAdvancedCache().getDataContainer();
        assert (dc2.size() == 10) : "Expected all the cache store entries to be preloaded on the second cache";
        for (int i = 0; i < 10; ++i) {
            this.assertOwnershipAndNonOwnership("k" + i, true);
        }
    }
}

