/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.rehash.WorkDuringJoinTest", enabled=false)
public class WorkDuringJoinTest
extends BaseDistFunctionalTest {
    EmbeddedCacheManager joinerManager;
    Cache<Object, String> joiner;

    public WorkDuringJoinTest() {
        this.INIT_CLUSTER_SIZE = 2;
    }

    private List<MagicKey> init() {
        ArrayList<MagicKey> keys = new ArrayList<MagicKey>(Arrays.asList(new MagicKey(this.c1, "k1"), new MagicKey(this.c2, "k2"), new MagicKey(this.c1, "k3"), new MagicKey(this.c2, "k4")));
        int i = 0;
        for (Cache c : this.caches) {
            c.put(keys.get(i++), (Object)("v" + i));
        }
        this.log.infof("Initialized with keys %s", keys);
        return keys;
    }

    Address startNewMember() {
        this.joinerManager = this.addClusterEnabledCacheManager();
        this.joinerManager.defineConfiguration(this.cacheName, this.configuration);
        this.joiner = this.joinerManager.getCache(this.cacheName);
        return this.manager(this.joiner).getAddress();
    }

    public void testJoinAndGet() {
        List<MagicKey> keys = this.init();
        ConsistentHash chOld = this.getConsistentHash(this.c1);
        Address joinerAddress = this.startNewMember();
        ConsistentHash chNew = ConsistentHashHelper.createConsistentHash((ConsistentHash)chOld, (Collection)chOld.getCaches(), (Address[])new Address[]{joinerAddress});
        MagicKey keyToTest = null;
        for (MagicKey k : keys) {
            if (!chNew.isKeyLocalToAddress(joinerAddress, (Object)k, this.numOwners)) continue;
            keyToTest = k;
            break;
        }
        if (keyToTest == null) {
            throw new NullPointerException("Couldn't find a key mapped to J!");
        }
        assert (this.joiner.get(keyToTest) != null);
    }
}

