/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.virtualnodes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.virtualnodes.IndexedJGroupsAddress;
import org.infinispan.distribution.virtualnodes.TransparentDefaultConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.jgroups.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="distribution.VNodesKeyDistributionTest", groups={"manual"}, enabled=false, description="See the results in vnodes_key_dist.txt")
public class VNodesKeyDistributionTest
extends AbstractInfinispanTest {
    public static final int[] NUM_NODES = new int[]{2, 4, 8, 16, 32, 48, 64, 128, 256};
    public static final int[] NUM_VIRTUAL_NODES = new int[]{1, 4, 16, 32, 48, 64, 96, 128};
    public static final int NUM_OWNERS = 2;
    public static final int LOOPS = 10000;
    public static final double[] INTERVALS = new double[]{1.25};
    public static final double[] INTERVALS_PRIMARY = new double[]{1.5};
    public static final double[] PERCENTILES = new double[]{0.999};

    private TransparentDefaultConsistentHash createConsistentHash(int numNodes, int numVirtualNodes) {
        MurmurHash3 hash = new MurmurHash3();
        TransparentDefaultConsistentHash ch = new TransparentDefaultConsistentHash();
        ch.setHashFunction((Hash)hash);
        ch.setNumVirtualNodes(numVirtualNodes);
        ch.setCaches(this.createAddresses(numNodes));
        return ch;
    }

    private Set<Address> createAddresses(int numNodes) {
        HashSet<Address> addresses = new HashSet<Address>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            addresses.add((Address)new IndexedJGroupsAddress((org.jgroups.Address)UUID.randomUUID(), i));
        }
        return addresses;
    }

    public void testDistribution() {
        for (int nn : NUM_NODES) {
            TreeMap<String, Map<Integer, String>> metrics = new TreeMap<String, Map<Integer, String>>();
            for (int vn : NUM_VIRTUAL_NODES) {
                for (Map.Entry<String, String> entry : this.computeMetrics(nn, vn, 2).entrySet()) {
                    String metricName = entry.getKey();
                    String metricValue = entry.getValue();
                    HashMap<Integer, String> metric = (HashMap<Integer, String>)metrics.get(metricName);
                    if (metric == null) {
                        metric = new HashMap<Integer, String>();
                        metrics.put(metricName, metric);
                    }
                    metric.put(vn, metricValue);
                }
            }
            this.printMetrics(nn, metrics);
        }
    }

    private void printMetrics(int nn, Map<String, Map<Integer, String>> metrics) {
        System.out.printf("Distribution for %3d nodes\n===\n", nn);
        System.out.printf("%-54s = ", "Virtual nodes");
        for (int i = 0; i < NUM_VIRTUAL_NODES.length; ++i) {
            System.out.printf("%7d", NUM_VIRTUAL_NODES[i]);
        }
        System.out.println();
        for (Map.Entry<String, Map<Integer, String>> entry : metrics.entrySet()) {
            String metricName = entry.getKey();
            Map<Integer, String> metricValues = entry.getValue();
            System.out.printf("%-54s = ", metricName);
            for (int i = 0; i < NUM_VIRTUAL_NODES.length; ++i) {
                System.out.print(metricValues.get(NUM_VIRTUAL_NODES[i]));
            }
            System.out.println();
        }
        System.out.println();
    }

    private Map<String, String> computeMetrics(int numNodes, int numVirtualNodes, int numOwners) {
        HashMap<String, String> metrics = new HashMap<String, String>();
        long[] distribution = new long[10000 * numNodes];
        long[] distributionPrimary = new long[10000 * numNodes];
        for (int i = 0; i < 10000; ++i) {
            TransparentDefaultConsistentHash ch = this.createConsistentHash(numNodes, numVirtualNodes);
            long[] dist = this.computeDistribution(numNodes, numOwners, ch);
            System.arraycopy(dist, 0, distribution, i * numNodes, numNodes);
            long[] distPrimary = this.computeDistribution(numNodes, 1, ch);
            System.arraycopy(distPrimary, 0, distributionPrimary, i * numNodes, numNodes);
        }
        Arrays.sort(distribution);
        Arrays.sort(distributionPrimary);
        this.addMetrics(metrics, "Any owner:", numNodes, numOwners, distribution, INTERVALS);
        this.addMetrics(metrics, "Primary:", numNodes, 1, distributionPrimary, INTERVALS_PRIMARY);
        return metrics;
    }

    private void addMetrics(Map<String, String> metrics, String prefix, int numNodes, int numOwners, long[] distribution, double[] intervals) {
        int i;
        int i2;
        double mean = 0.0;
        long sum = 0L;
        for (long x : distribution) {
            sum += x;
        }
        Assert.assertEquals((long)sum, (long)((long)(10000 * numOwners) * Integer.MAX_VALUE));
        mean = sum / (long)numNodes / 10000L;
        double variance = 0.0;
        for (long x : distribution) {
            variance += ((double)x - mean) * ((double)x - mean);
        }
        double stdDev = Math.sqrt(variance);
        long max = distribution[distribution.length - 1];
        this.addDoubleMetric(metrics, prefix + " max(num_keys(node)/mean)", (double)max / mean);
        double[] intervalConfidence = new double[intervals.length];
        int intervalIndex = 0;
        for (i2 = 0; i2 < distribution.length; ++i2) {
            long x = distribution[i2];
            if (!((double)x > intervals[intervalIndex] * mean)) continue;
            intervalConfidence[intervalIndex] = (double)i2 / (double)distribution.length;
            if (++intervalIndex >= intervals.length) break;
        }
        for (i2 = intervalIndex; i2 < intervals.length; ++i2) {
            intervalConfidence[i2] = 1.0;
        }
        for (i2 = 0; i2 < intervals.length; ++i2) {
            if (intervals[i2] < 1.0) {
                this.addPercentageMetric(metrics, String.format("%s P(num_keys(node) < %3.2f * mean)", prefix, intervals[i2]), intervalConfidence[i2]);
                continue;
            }
            this.addPercentageMetric(metrics, String.format("%s P(num_keys(node) > %3.2f * mean)", prefix, intervals[i2]), 1.0 - intervalConfidence[i2]);
        }
        double[] percentiles = new double[PERCENTILES.length];
        for (i = 0; i < PERCENTILES.length; ++i) {
            percentiles[i] = (double)distribution[(int)Math.ceil(PERCENTILES[i] * (double)(10000 * numNodes + 1))] / mean;
        }
        for (i = 0; i < PERCENTILES.length; ++i) {
            this.addDoubleMetric(metrics, String.format("%s P(num_keys(node) <= x * mean) = %5.2f%% => x", prefix, PERCENTILES[i] * 100.0), percentiles[i]);
        }
    }

    private void addDoubleMetric(Map<String, String> metrics, String name, double value) {
        metrics.put(name, String.format("%7.3f", value));
    }

    private void addPercentageMetric(Map<String, String> metrics, String name, double value) {
        metrics.put(name, String.format("%6.2f%%", value * 100.0));
    }

    private long[] computeDistribution(int numNodes, int numOwners, TransparentDefaultConsistentHash ch) {
        long[] distribution = new long[numNodes];
        int[] hashPositions = ch.getHashPositions();
        for (int i = 0; i < hashPositions.length; ++i) {
            int hashPosition = hashPositions[i];
            int previousHashPosition = i > 0 ? hashPositions[i - 1] : hashPositions[hashPositions.length - 1];
            List<Address> owners = ch.locateHash(hashPosition, numOwners);
            for (Address a : owners) {
                IndexedJGroupsAddress ma = (IndexedJGroupsAddress)a;
                int n = ma.nodeIndex;
                distribution[n] = distribution[n] + (hashPosition > previousHashPosition ? (long)(hashPosition - previousHashPosition) : (long)(Integer.MAX_VALUE + hashPosition - previousHashPosition));
            }
        }
        return distribution;
    }
}

