/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.virtualnodes;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="distribution.virtualnodes.VNodesXmlTest", groups={"functional"})
public class VNodesXmlTest
extends AbstractInfinispanTest {
    public void testParseFile() throws Exception {
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\"><global><transport /></global>   <default>\n      <clustering mode=\"d\">\n          <hash numVirtualNodes=\"5000\" />      </clustering>\n   </default>\n   <namedCache name=\"x\" /></infinispan>";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        ConfigurationBuilderHolder holder = new Parser(Thread.currentThread().getContextClassLoader()).parse((InputStream)is);
        org.infinispan.configuration.cache.Configuration defaultCfg = holder.getDefaultConfigurationBuilder().build();
        org.infinispan.configuration.cache.Configuration namedCfg = ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("x")).build();
        for (org.infinispan.configuration.cache.Configuration c : Arrays.asList(defaultCfg, namedCfg)) {
            Assert.assertEquals((Object)c.clustering().cacheMode(), (Object)CacheMode.DIST_SYNC);
            Assert.assertEquals((int)c.clustering().hash().numVirtualNodes(), (int)5000);
            Configuration legacy = LegacyConfigurationAdaptor.adapt((org.infinispan.configuration.cache.Configuration)c);
            Assert.assertEquals((String)legacy.getCacheMode().toString(), (String)CacheMode.DIST_SYNC.toString());
            Assert.assertEquals((int)legacy.getNumVirtualNodes(), (int)5000);
        }
    }
}

