/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionManagerImpl;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="eviction.EvictionManagerTest")
public class EvictionManagerTest
extends AbstractInfinispanTest {
    private Configuration getCfg() {
        return new Configuration().fluent().eviction().strategy(EvictionStrategy.LRU).build();
    }

    public void testNoEvictionThread() {
        EvictionManagerImpl em = new EvictionManagerImpl();
        Configuration cfg = this.getCfg().fluent().expiration().wakeUpInterval(Long.valueOf(0L)).build();
        ScheduledExecutorService mockService = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        em.initialize(mockService, cfg, null, null, null);
        EasyMock.replay((Object[])new Object[]{mockService});
        em.start();
        assert (em.evictionTask == null) : "Eviction task is not null!  Should not have scheduled anything!";
        EasyMock.verify((Object[])new Object[]{mockService});
    }

    public void testWakeupInterval() {
        EvictionManagerImpl em = new EvictionManagerImpl();
        Configuration cfg = this.getCfg().fluent().expiration().wakeUpInterval(Long.valueOf(789L)).build();
        ScheduledExecutorService mockService = (ScheduledExecutorService)EasyMock.createMock(ScheduledExecutorService.class);
        em.initialize(mockService, cfg, null, null, null);
        ScheduledFuture mockFuture = (ScheduledFuture)EasyMock.createNiceMock(ScheduledFuture.class);
        EasyMock.expect(mockService.scheduleWithFixedDelay((Runnable)EasyMock.isA(EvictionManagerImpl.ScheduledTask.class), EasyMock.eq((long)789L), EasyMock.eq((long)789L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andReturn((Object)mockFuture).once();
        EasyMock.replay((Object[])new Object[]{mockService});
        em.start();
        assert (em.evictionTask == mockFuture);
        EasyMock.verify((Object[])new Object[]{mockService});
    }
}

