/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionWithPassivationTest")
public class EvictionWithPassivationTest
extends SingleCacheManagerTest {
    private Configuration buildCfg(EvictionThreadPolicy threadPolicy, EvictionStrategy strategy) {
        Configuration cfg = new Configuration();
        DummyInMemoryCacheStore.Cfg cacheStoreConfig = new DummyInMemoryCacheStore.Cfg();
        cacheStoreConfig.setPurgeOnStartup(true);
        cfg.getCacheLoaderManagerConfig().addCacheLoaderConfig((CacheLoaderConfig)cacheStoreConfig);
        cfg.getCacheLoaderManagerConfig().setPassivation(Boolean.valueOf(true));
        cfg.setEvictionStrategy(strategy);
        cfg.setEvictionThreadPolicy(threadPolicy);
        cfg.setEvictionMaxEntries(2);
        cfg.setInvocationBatchingEnabled(true);
        return cfg;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = new DefaultCacheManager(this.getDefaultStandaloneConfig(true));
        for (EvictionStrategy s : EvictionStrategy.values()) {
            for (EvictionThreadPolicy p : EvictionThreadPolicy.values()) {
                this.cacheManager.defineConfiguration("test-" + p + "-" + s, this.buildCfg(p, s));
            }
        }
        return this.cacheManager;
    }

    public void testPiggybackLRU() {
        this.runTest(EvictionThreadPolicy.PIGGYBACK, EvictionStrategy.LRU);
    }

    public void testPiggybackLIRS() {
        this.runTest(EvictionThreadPolicy.PIGGYBACK, EvictionStrategy.LIRS);
    }

    public void testPiggybackNONE() {
        this.runTest(EvictionThreadPolicy.PIGGYBACK, EvictionStrategy.NONE);
    }

    public void testPiggybackUNORDERED() {
        this.runTest(EvictionThreadPolicy.PIGGYBACK, EvictionStrategy.UNORDERED);
    }

    public void testDefaultLRU() {
        this.runTest(EvictionThreadPolicy.DEFAULT, EvictionStrategy.LRU);
    }

    public void testDefaultLIRS() {
        this.runTest(EvictionThreadPolicy.DEFAULT, EvictionStrategy.LIRS);
    }

    public void testDefaultNONE() {
        this.runTest(EvictionThreadPolicy.DEFAULT, EvictionStrategy.NONE);
    }

    public void testDefaultUNORDERED() {
        this.runTest(EvictionThreadPolicy.DEFAULT, EvictionStrategy.UNORDERED);
    }

    private void runTest(EvictionThreadPolicy p, EvictionStrategy s) {
        String k;
        int i;
        String name = "test-" + p + "-" + s;
        Cache testCache = this.cacheManager.getCache(name);
        testCache.clear();
        testCache.put((Object)"X", (Object)"4567");
        testCache.put((Object)"Y", (Object)"4568");
        testCache.put((Object)"Z", (Object)"4569");
        assert ("4567".equals(testCache.get((Object)"X"))) : "Failure on test " + name;
        assert ("4568".equals(testCache.get((Object)"Y"))) : "Failure on test " + name;
        assert ("4569".equals(testCache.get((Object)"Z"))) : "Failure on test " + name;
        for (i = 0; i < 10; ++i) {
            testCache.getAdvancedCache().startBatch();
            k = "A" + i;
            testCache.put((Object)k, (Object)k);
            k = "B" + i;
            testCache.put((Object)k, (Object)k);
            testCache.getAdvancedCache().endBatch(true);
        }
        for (i = 0; i < 10; ++i) {
            k = "A" + i;
            assert (k.equals(testCache.get((Object)k))) : "Failure on test " + name;
            k = "B" + i;
            assert (k.equals(testCache.get((Object)k))) : "Failure on test " + name;
        }
    }
}

