/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.InternalEntryFactoryImpl;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jgroups.util.Util;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.MarshalledValuesEvictionTest", enabled=false, description="Is this test even valid?  Evictions don't go thru the marshalled value interceptor when initiated form the data container!")
public class MarshalledValuesEvictionTest
extends SingleCacheManagerTest {
    private static final int CACHE_SIZE = 128;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration cfg = new Configuration().fluent().eviction().strategy(EvictionStrategy.LRU).maxEntries(Integer.valueOf(128)).expiration().wakeUpInterval(Long.valueOf(100L)).locking().useLockStriping(Boolean.valueOf(false)).storeAsBinary().build();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfg);
        this.cache = cm.getCache();
        StreamingMarshaller marshaller = TestingUtil.extractComponent(this.cache, StreamingMarshaller.class);
        MockMarshalledValueInterceptor interceptor = new MockMarshalledValueInterceptor(marshaller);
        assert (TestingUtil.replaceInterceptor(this.cache, (CommandInterceptor)interceptor, MarshalledValueInterceptor.class));
        return cm;
    }

    public void testEvictCustomKeyValue() {
        for (int i = 0; i < 256; ++i) {
            EvictionPojo p1 = new EvictionPojo();
            p1.i = (int)Util.random((long)2000L);
            EvictionPojo p2 = new EvictionPojo();
            p2.i = 24;
            this.cache.put((Object)p1, (Object)p2);
        }
        long giveupTime = System.currentTimeMillis() + 10000L;
        while (this.cache.getAdvancedCache().getDataContainer().size() > 128 && System.currentTimeMillis() < giveupTime) {
            TestingUtil.sleepThread(100L);
        }
        assert (this.cache.getAdvancedCache().getDataContainer().size() <= 128) : "Expected 1, was " + this.cache.size();
        Util.sleep((long)3000L);
        MockMarshalledValueInterceptor interceptor = (MockMarshalledValueInterceptor)TestingUtil.findInterceptor(this.cache, MarshalledValueInterceptor.class);
        assert (!interceptor.marshalledValueCreated);
    }

    public void testEvictPrimitiveKeyCustomValue() {
        for (int i = 0; i < 256; ++i) {
            EvictionPojo p1 = new EvictionPojo();
            p1.i = (int)Util.random((long)2000L);
            EvictionPojo p2 = new EvictionPojo();
            p2.i = 24;
            this.cache.put((Object)p1, (Object)p2);
        }
        long giveupTime = System.currentTimeMillis() + 10000L;
        while (this.cache.getAdvancedCache().getDataContainer().size() > 128 && System.currentTimeMillis() < giveupTime) {
            TestingUtil.sleepThread(100L);
        }
        assert (this.cache.getAdvancedCache().getDataContainer().size() <= 128) : "Expected 1, was " + this.cache.size();
        Util.sleep((long)3000L);
        MockMarshalledValueInterceptor interceptor = (MockMarshalledValueInterceptor)TestingUtil.findInterceptor(this.cache, MarshalledValueInterceptor.class);
        assert (!interceptor.marshalledValueCreated);
    }

    static class EvictionPojo
    implements Externalizable {
        int i;

        EvictionPojo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvictionPojo pojo = (EvictionPojo)o;
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            return result;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.i);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.i = in.readInt();
        }
    }

    static class MockMarshalledValueInterceptor
    extends MarshalledValueInterceptor {
        boolean marshalledValueCreated;

        MockMarshalledValueInterceptor(StreamingMarshaller marshaller) {
            this.injectMarshaller(marshaller, (InternalEntryFactory)new InternalEntryFactoryImpl());
        }

        protected MarshalledValue createMarshalledValue(Object toWrap, InvocationContext ctx) {
            this.marshalledValueCreated = true;
            return super.createMarshalledValue(toWrap, ctx);
        }

        public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
            if (this.marshalledValueCreated) {
                this.marshalledValueCreated = false;
            }
            return super.visitEvictCommand(ctx, command);
        }
    }
}

