/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import org.easymock.classextension.EasyMock;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.AbstractCacheStoreTest")
public class AbstractCacheStoreTest
extends AbstractInfinispanTest {
    private AbstractCacheStore cs;
    private AbstractCacheStoreConfig cfg;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws NoSuchMethodException, CacheLoaderException {
        this.cs = (AbstractCacheStore)EasyMock.createMock(AbstractCacheStore.class, (Method[])new Method[]{AbstractCacheStore.class.getMethod("clear", new Class[0])});
        this.cfg = new AbstractCacheStoreConfig();
        this.cs.init((CacheLoaderConfig)this.cfg, null, null);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        this.cs.stop();
        this.cs = null;
        this.cfg = null;
    }

    @Test
    void testSyncExecutorIsSetWhenCfgPurgeSyncIsTrueOnStart() throws Exception {
        this.cfg.setPurgeSynchronously(Boolean.valueOf(true));
        this.cs.start();
        ExecutorService service = (ExecutorService)ReflectionUtil.getValue((Object)this.cs, (String)"purgerService");
        assert (service instanceof WithinThreadExecutor);
    }

    @Test
    void testAsyncExecutorIsDefaultOnStart() throws Exception {
        this.cs.start();
        ExecutorService service = (ExecutorService)ReflectionUtil.getValue((Object)this.cs, (String)"purgerService");
        assert (!(service instanceof WithinThreadExecutor));
    }
}

