/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(testName="loaders.ReplicatedSharedEvictingLoaderTest", groups={"functional"})
public class ReplicatedSharedEvictingLoaderTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        clmc.addCacheLoaderConfig((CacheLoaderConfig)new DummyInMemoryCacheStore.Cfg("ReplicatedSharedEvictingLoaderTest"));
        clmc.setShared(Boolean.valueOf(true));
        clmc.setPassivation(Boolean.valueOf(true));
        c.setCacheLoaderManagerConfig(clmc);
        this.createCluster(c, 2);
        this.waitForClusterToForm();
    }

    public void testRemovalFromCacheStoreOnEvict() {
        this.cache(0).put((Object)"k", (Object)"v");
        assert ("v".equals(this.cache(0).get((Object)"k")));
        assert ("v".equals(this.cache(1).get((Object)"k")));
        this.cache(0).evict((Object)"k");
        this.cache(1).evict((Object)"k");
        assert ("v".equals(this.cache(0).get((Object)"k")));
        assert ("v".equals(this.cache(1).get((Object)"k")));
    }
}

