/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(testName="loaders.SharedCacheStoreTest", groups={"functional"})
public class SharedCacheStoreTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = new Configuration().fluent().loaders().shared(Boolean.valueOf(true)).addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg().storeName(SharedCacheStoreTest.class.getName()).purgeOnStartup(false)}).clustering().mode(Configuration.CacheMode.REPL_SYNC).build();
        this.createCluster(cfg, 3);
    }

    private List<CacheStore> cachestores() {
        LinkedList<CacheStore> l = new LinkedList<CacheStore>();
        for (Cache c : this.caches()) {
            l.add(TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore());
        }
        return l;
    }

    public void testUnnecessaryWrites() throws CacheLoaderException {
        DummyInMemoryCacheStore dimcs;
        this.cache(0).put((Object)"key", (Object)"value");
        for (Cache c : this.caches()) {
            assert ("value".equals(c.get((Object)"key")));
        }
        for (CacheStore cs : this.cachestores()) {
            assert (cs.containsKey((Object)"key"));
            dimcs = (DummyInMemoryCacheStore)cs;
            assert (dimcs.stats().get("clear") == 0) : "Cache store should not be cleared, purgeOnStartup is false";
            assert (dimcs.stats().get("store") == 1) : "Cache store should have been written to just once, but was written to " + dimcs.stats().get("store") + " times";
        }
        this.cache(0).remove((Object)"key");
        for (Cache c : this.caches()) {
            assert (c.get((Object)"key") == null);
        }
        for (CacheStore cs : this.cachestores()) {
            assert (!cs.containsKey((Object)"key"));
            dimcs = (DummyInMemoryCacheStore)cs;
            assert (dimcs.stats().get("remove") == 1) : "Entry should have been removed from the cache store just once, but was removed " + dimcs.stats().get("store") + " times";
        }
    }
}

