/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.CacheException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AsyncStore;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.decorators.AsyncTest", sequential=true)
public class AsyncTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(AsyncTest.class);
    AsyncStore store;
    ExecutorService asyncExecutor;
    DummyInMemoryCacheStore underlying;
    AsyncStoreConfig asyncConfig;
    DummyInMemoryCacheStore.Cfg dummyCfg;

    @BeforeMethod
    public void setUp() throws CacheLoaderException {
        this.underlying = new DummyInMemoryCacheStore();
        this.asyncConfig = new AsyncStoreConfig().threadPoolSize(Integer.valueOf(10));
        this.store = new AsyncStore((CacheStore)this.underlying, this.asyncConfig);
        this.dummyCfg = new DummyInMemoryCacheStore.Cfg().storeName(AsyncTest.class.getName());
        this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
        this.store.start();
        this.asyncExecutor = (ExecutorService)TestingUtil.extractField(this.store, "executor");
    }

    @AfterMethod
    public void tearDown() throws CacheLoaderException {
        if (this.store != null) {
            this.store.stop();
        }
    }

    @Test(timeOut=10000L)
    public void testPutRemove() throws Exception {
        int number = 1000;
        String key = "testPutRemove-k-";
        String value = "testPutRemove-v-";
        this.doTestPut(1000, key, value);
        this.doTestRemove(1000, key);
    }

    @Test(timeOut=10000L)
    public void testPutClearPut() throws Exception {
        int number = 1000;
        String key = "testPutClearPut-k-";
        String value = "testPutClearPut-v-";
        this.doTestPut(1000, key, value);
        this.doTestClear(1000, key);
        value = "testPutClearPut-v[2]-";
        this.doTestPut(1000, key, value);
        this.doTestRemove(1000, key);
    }

    @Test(timeOut=10000L)
    public void testMultiplePutsOnSameKey() throws Exception {
        int number = 1000;
        String key = "testMultiplePutsOnSameKey-k";
        String value = "testMultiplePutsOnSameKey-v-";
        this.doTestSameKeyPut(1000, key, value);
        this.doTestSameKeyRemove(key);
    }

    @Test(timeOut=10000L)
    public void testRestrictionOnAddingToAsyncQueue() throws Exception {
        this.store.remove((Object)"blah");
        int number = 10;
        String key = "testRestrictionOnAddingToAsyncQueue-k";
        String value = "testRestrictionOnAddingToAsyncQueue-v-";
        this.doTestPut(10, key, value);
        this.store.stop();
        try {
            this.store.remove((Object)"blah");
            assert (false) : "Should have restricted this entry from being made";
        }
        catch (CacheException expected) {
            // empty catch block
        }
        this.store.start();
        this.doTestRemove(10, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThreadSafetyWritingDiffValuesForKey(Method m) throws Exception {
        try {
            String key = "k1";
            CountDownLatch v1Latch = new CountDownLatch(1);
            CountDownLatch v2Latch = new CountDownLatch(1);
            CountDownLatch endLatch = new CountDownLatch(1);
            DummyInMemoryCacheStore underlying = new DummyInMemoryCacheStore();
            this.store = new MockAsyncStore("k1", v1Latch, v2Latch, endLatch, (CacheStore)underlying, this.asyncConfig);
            this.dummyCfg = new DummyInMemoryCacheStore.Cfg();
            this.dummyCfg.setStoreName(m.getName());
            this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
            this.store.start();
            this.store.store(TestInternalCacheEntryFactory.create("k1", "v1"));
            v2Latch.await();
            this.store.store(TestInternalCacheEntryFactory.create("k1", "v2"));
            endLatch.await();
            assert (this.store.load((Object)"k1").getValue().equals("v2"));
        }
        finally {
            this.store.delegate.clear();
            this.store.stop();
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalModificationsHappenInDiffThread(Method m) throws Exception {
        try {
            TransactionFactory gtf = new TransactionFactory();
            gtf.init(false, false, true);
            String k1 = TestingUtil.k(m, 1);
            String k2 = TestingUtil.k(m, 2);
            String v1 = TestingUtil.v(m, 1);
            String v2 = TestingUtil.v(m, 2);
            final ConcurrentHashMap localMods = new ConcurrentHashMap();
            final CyclicBarrier barrier = new CyclicBarrier(2);
            DummyInMemoryCacheStore underlying = new DummyInMemoryCacheStore();
            this.store = new AsyncStore((CacheStore)underlying, this.asyncConfig){

                protected void applyModificationsSync(ConcurrentMap<Object, Modification> mods) throws CacheLoaderException {
                    for (Map.Entry entry : mods.entrySet()) {
                        localMods.put(entry.getKey(), entry.getValue());
                    }
                    super.applyModificationsSync(mods);
                    try {
                        barrier.await(5L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        assert (false) : "Timed out applying for modifications";
                    }
                    catch (Exception e) {
                        throw new CacheLoaderException("Barrier failed", (Throwable)e);
                    }
                }
            };
            this.dummyCfg = new DummyInMemoryCacheStore.Cfg();
            this.dummyCfg.setStoreName(m.getName());
            this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
            this.store.start();
            ArrayList<Object> mods = new ArrayList<Object>();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k1));
            GlobalTransaction tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            assert (0 == localMods.size());
            assert (!this.store.containsKey((Object)k1));
            assert (!this.store.containsKey((Object)k2));
            this.store.commit(tx);
            barrier.await(5L, TimeUnit.SECONDS);
            assert (this.store.load((Object)k2).getValue().equals(v2));
            assert (!this.store.containsKey((Object)k1));
            assert (2 == localMods.size());
            assert (new Remove((Object)k1).equals(localMods.get(k1)));
        }
        finally {
            this.store.delegate.clear();
            this.store.stop();
            this.store = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionalModificationsAreCoalesced(Method m) throws Exception {
        try {
            TransactionFactory gtf = new TransactionFactory();
            gtf.init(false, false, true);
            String k1 = TestingUtil.k(m, 1);
            String k2 = TestingUtil.k(m, 2);
            String k3 = TestingUtil.k(m, 3);
            String v1 = TestingUtil.v(m, 1);
            String v2 = TestingUtil.v(m, 2);
            String v3 = TestingUtil.v(m, 3);
            final AtomicInteger storeCount = new AtomicInteger();
            final AtomicInteger removeCount = new AtomicInteger();
            final AtomicInteger clearCount = new AtomicInteger();
            final CyclicBarrier barrier = new CyclicBarrier(2);
            DummyInMemoryCacheStore underlying = new DummyInMemoryCacheStore(){

                @Override
                public void store(InternalCacheEntry ed) {
                    super.store(ed);
                    storeCount.getAndIncrement();
                }

                @Override
                public boolean remove(Object key) {
                    boolean ret = super.remove(key);
                    removeCount.getAndIncrement();
                    return ret;
                }

                @Override
                public void clear() {
                    super.clear();
                    clearCount.getAndIncrement();
                }
            };
            this.store = new AsyncStore((CacheStore)underlying, this.asyncConfig){

                protected void applyModificationsSync(ConcurrentMap<Object, Modification> mods) throws CacheLoaderException {
                    super.applyModificationsSync(mods);
                    try {
                        barrier.await(5L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException e) {
                        assert (false) : "Timed out applying for modifications";
                    }
                    catch (Exception e) {
                        throw new CacheLoaderException("Barrier failed", (Throwable)e);
                    }
                }
            };
            this.dummyCfg = new DummyInMemoryCacheStore.Cfg();
            this.dummyCfg.setStoreName(m.getName());
            this.store.init((CacheLoaderConfig)this.dummyCfg, null, null);
            this.store.start();
            ArrayList<Object> mods = new ArrayList<Object>();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v2)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v1)));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k1));
            GlobalTransaction tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(5L, TimeUnit.SECONDS);
            assert (1 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (1 == removeCount.get());
            assert (0 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Remove((Object)k1));
            mods.add(new Clear());
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k2));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(5L, TimeUnit.SECONDS);
            assert (0 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (1 == removeCount.get());
            assert (1 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            mods.add(new Remove((Object)k1));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k2, v2)));
            mods.add(new Remove((Object)k2));
            mods.add(new Store(TestInternalCacheEntryFactory.create(k3, v3)));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(5L, TimeUnit.SECONDS);
            assert (1 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (2 == removeCount.get());
            assert (0 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Clear());
            mods.add(new Remove((Object)k1));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(5L, TimeUnit.SECONDS);
            assert (0 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (1 == removeCount.get());
            assert (1 == clearCount.get());
            storeCount.set(0);
            removeCount.set(0);
            clearCount.set(0);
            mods = new ArrayList();
            mods.add(new Clear());
            mods.add(new Store(TestInternalCacheEntryFactory.create(k1, v1)));
            tx = gtf.newGlobalTransaction(null, false);
            this.store.prepare(mods, tx, false);
            Thread.sleep(200L);
            assert (0 == storeCount.get());
            assert (0 == removeCount.get());
            assert (0 == clearCount.get());
            this.store.commit(tx);
            barrier.await(5L, TimeUnit.SECONDS);
            assert (1 == storeCount.get()) : "Store count was " + storeCount.get();
            assert (0 == removeCount.get());
            assert (1 == clearCount.get());
        }
        finally {
            this.store.delegate.clear();
            this.store.stop();
            this.store = null;
        }
    }

    private void doTestPut(int number, String key, String value) throws Exception {
        int i;
        for (int i2 = 0; i2 < number; ++i2) {
            InternalCacheEntry cacheEntry = TestInternalCacheEntryFactory.create(key + i2, value + i2);
            this.store.store(cacheEntry);
        }
        this.store.stop();
        this.store.start();
        InternalCacheEntry[] entries = new InternalCacheEntry[number];
        for (i = 0; i < number; ++i) {
            entries[i] = this.store.load((Object)(key + i));
        }
        for (i = 0; i < number; ++i) {
            InternalCacheEntry entry = entries[i];
            if (entry != null) {
                assert (entry.getValue().equals(value + i));
                continue;
            }
            while (entry == null) {
                entry = this.store.load((Object)(key + i));
                if (entry != null) {
                    assert (entry.getValue().equals(value + i));
                    continue;
                }
                TestingUtil.sleepThreadInt(20L, "still waiting for key to appear: " + key + i);
            }
        }
    }

    private void doTestSameKeyPut(int number, String key, String value) throws Exception {
        for (int i = 0; i < number; ++i) {
            this.store.store(TestInternalCacheEntryFactory.create(key, value + i));
        }
        this.store.stop();
        this.store.start();
        boolean success = false;
        for (int i = 0; i < 120; ++i) {
            TestingUtil.sleepThreadInt(20L, null);
            InternalCacheEntry entry = this.store.load((Object)key);
            success = entry.getValue().equals(value + (number - 1));
            if (success) break;
        }
        assert (success);
    }

    private void doTestRemove(int number, String key) throws Exception {
        int i;
        for (int i2 = 0; i2 < number; ++i2) {
            this.store.remove((Object)(key + i2));
        }
        this.store.stop();
        this.store.start();
        InternalCacheEntry[] entries = new InternalCacheEntry[number];
        for (i = 0; i < number; ++i) {
            entries[i] = this.store.load((Object)(key + i));
        }
        for (i = 0; i < number; ++i) {
            InternalCacheEntry entry = entries[i];
            while (entry != null) {
                TestingUtil.sleepThreadInt(20L, "still waiting for key to be removed: " + key + i);
                entry = this.store.load((Object)(key + i));
            }
        }
    }

    private void doTestSameKeyRemove(String key) throws Exception {
        InternalCacheEntry entry;
        this.store.remove((Object)key);
        do {
            TestingUtil.sleepThreadInt(20L, "still waiting for key to be removed: " + key);
        } while ((entry = this.store.load((Object)key)) != null);
    }

    private void doTestClear(int number, String key) throws Exception {
        int i;
        this.store.clear();
        this.store.stop();
        this.store.start();
        InternalCacheEntry[] entries = new InternalCacheEntry[number];
        for (i = 0; i < number; ++i) {
            entries[i] = this.store.load((Object)(key + i));
        }
        for (i = 0; i < number; ++i) {
            InternalCacheEntry entry = entries[i];
            while (entry != null) {
                TestingUtil.sleepThreadInt(20L, "still waiting for key to be removed: " + key + i);
                entry = this.store.load((Object)(key + i));
            }
        }
    }

    static class MockAsyncStore
    extends AsyncStore {
        volatile boolean block = true;
        final CountDownLatch v1Latch;
        final CountDownLatch v2Latch;
        final CountDownLatch endLatch;
        final Object key;

        MockAsyncStore(Object key, CountDownLatch v1Latch, CountDownLatch v2Latch, CountDownLatch endLatch, CacheStore delegate, AsyncStoreConfig asyncStoreConfig) {
            super(delegate, asyncStoreConfig);
            this.v1Latch = v1Latch;
            this.v2Latch = v2Latch;
            this.endLatch = endLatch;
            this.key = key;
        }

        protected void applyModificationsSync(ConcurrentMap<Object, Modification> mods) throws CacheLoaderException {
            if (mods.get(this.key) != null && this.block) {
                log.trace((Object)"Wait for v1 latch");
                try {
                    this.v2Latch.countDown();
                    this.block = false;
                    this.v1Latch.await(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                super.applyModificationsSync(mods);
            } else if (mods.get(this.key) != null && !this.block) {
                log.trace((Object)"Do v2 modification and unleash v1 latch");
                super.applyModificationsSync(mods);
                this.v1Latch.countDown();
                this.endLatch.countDown();
            }
        }
    }
}

