/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.file;

import java.io.File;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.file.ClusterFileCacheStoreFunctionalTest")
public class ClusterFileCacheStoreFunctionalTest
extends MultipleCacheManagersTest {
    private final String tmpDirectory = TestingUtil.tmpDirectory("/tmp", this);
    private Cache cache1;
    private Cache cache2;

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.tmpDirectory);
        new File(this.tmpDirectory).mkdirs();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), new Configuration());
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createCacheManager(GlobalConfiguration.getClusteredDefault(), new Configuration());
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        Configuration config1 = ClusterFileCacheStoreFunctionalTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        CacheLoaderManagerConfig clMngrConfig = new CacheLoaderManagerConfig();
        clMngrConfig.addCacheLoaderConfig((CacheLoaderConfig)this.createCacheStoreConfig(1));
        config1.setCacheLoaderManagerConfig(clMngrConfig);
        Configuration config2 = ClusterFileCacheStoreFunctionalTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        CacheLoaderManagerConfig clMngrConfig2 = new CacheLoaderManagerConfig();
        clMngrConfig2.addCacheLoaderConfig((CacheLoaderConfig)this.createCacheStoreConfig(2));
        config2.setCacheLoaderManagerConfig(clMngrConfig2);
        cacheManager1.defineConfiguration("clusteredFileCacheStore", config1);
        cacheManager2.defineConfiguration("clusteredFileCacheStore", config2);
        this.cache1 = this.cache(0, "clusteredFileCacheStore");
        this.cache2 = this.cache(1, "clusteredFileCacheStore");
    }

    public void testRestoreTransactionalAtomicMap(Method m) throws Exception {
        TransactionManager tm = this.cache1.getAdvancedCache().getTransactionManager();
        tm.begin();
        AtomicMap map = AtomicMapLookup.getAtomicMap((Cache)this.cache1, (Object)m.getName());
        map.put((Object)"a", (Object)"b");
        tm.commit();
        this.cache1.evict((Object)m.getName());
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache1, (Object)m.getName()).get((Object)"a").equals("b"));
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache2, (Object)m.getName()).get((Object)"a").equals("b"));
        this.cache2.evict((Object)m.getName());
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache1, (Object)m.getName()).get((Object)"a").equals("b"));
        assert (AtomicMapLookup.getAtomicMap((Cache)this.cache2, (Object)m.getName()).get((Object)"a").equals("b"));
    }

    protected CacheStoreConfig createCacheStoreConfig(int index) throws Exception {
        FileCacheStoreConfig cfg = new FileCacheStoreConfig();
        cfg.setLocation(this.tmpDirectory + "/" + index);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        return cfg;
    }
}

