/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock;

import java.util.Collections;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.CheckRemoteLockAcquiredOnlyOnceTest")
public class CheckRemoteLockAcquiredOnlyOnceTest
extends MultipleCacheManagersTest {
    protected ControlInterceptor controlInterceptor;
    protected Object key;
    protected Configuration.CacheMode mode = Configuration.CacheMode.REPL_SYNC;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = CheckRemoteLockAcquiredOnlyOnceTest.getDefaultClusteredConfig(this.mode, true);
        c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.controlInterceptor = new ControlInterceptor();
        this.cache(0).getAdvancedCache().addInterceptor((CommandInterceptor)this.controlInterceptor, 1);
        this.key = "k";
    }

    public void testLockThenLock() throws Exception {
        this.testLockThenOperation(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.advancedCache(1).lock(new Object[]{CheckRemoteLockAcquiredOnlyOnceTest.this.key});
            }
        });
    }

    public void testLockThenPut() throws Exception {
        this.testLockThenOperation(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).put(CheckRemoteLockAcquiredOnlyOnceTest.this.key, (Object)"v");
            }
        });
    }

    public void testLockThenRemove() throws Exception {
        this.testLockThenOperation(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).remove(CheckRemoteLockAcquiredOnlyOnceTest.this.key);
            }
        });
    }

    public void testLockThenReplace() throws Exception {
        this.testLockThenOperation(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).replace(CheckRemoteLockAcquiredOnlyOnceTest.this.key, (Object)"", (Object)"v");
            }
        });
    }

    public void testLockThenPutAll() throws Exception {
        this.testLockThenOperation(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).putAll(Collections.singletonMap(CheckRemoteLockAcquiredOnlyOnceTest.this.key, "value"));
            }
        });
    }

    public void testPutThenLock() throws Exception {
        this.testOperationThenLock(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).put(CheckRemoteLockAcquiredOnlyOnceTest.this.key, (Object)"v");
            }
        });
    }

    public void testRemoveThenLock() throws Exception {
        this.testOperationThenLock(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).remove(CheckRemoteLockAcquiredOnlyOnceTest.this.key);
            }
        });
    }

    public void testReplaceThenLock() throws Exception {
        this.testOperationThenLock(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).replace(CheckRemoteLockAcquiredOnlyOnceTest.this.key, (Object)"", (Object)"v");
            }
        });
    }

    public void testPutAllThenLock() throws Exception {
        this.testOperationThenLock(new CacheOperation(){

            @Override
            public void execute() {
                CheckRemoteLockAcquiredOnlyOnceTest.this.cache(1).putAll(Collections.singletonMap(CheckRemoteLockAcquiredOnlyOnceTest.this.key, "value"));
            }
        });
    }

    private void testLockThenOperation(CacheOperation o) throws Exception {
        assert (this.controlInterceptor.remoteInvocations == 0);
        this.tm(1).begin();
        this.advancedCache(1).lock(new Object[]{this.key});
        assert (this.lockManager(0).isLocked(this.key));
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)1);
        for (int i = 0; i < 100; ++i) {
            o.execute();
        }
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)1);
        this.tm(1).commit();
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)1);
        this.controlInterceptor.remoteInvocations = 0;
    }

    private void testOperationThenLock(CacheOperation o) throws Exception {
        assert (this.controlInterceptor.remoteInvocations == 0);
        this.tm(1).begin();
        for (int i = 0; i < 100; ++i) {
            o.execute();
        }
        assert (this.lockManager(0).isLocked(this.key));
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)1);
        this.advancedCache(1).lock(new Object[]{this.key});
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)1);
        this.tm(1).commit();
        Assert.assertEquals((int)this.controlInterceptor.remoteInvocations, (int)1);
        this.controlInterceptor.remoteInvocations = 0;
    }

    public static interface CacheOperation {
        public void execute();
    }

    public static class ControlInterceptor
    extends CommandInterceptor {
        volatile int remoteInvocations = 0;

        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                ++this.remoteInvocations;
            }
            return super.visitLockControlCommand(ctx, command);
        }
    }
}

