/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="marshall.StoreAsBinaryConfigTest")
public class StoreAsBinaryConfigTest
extends AbstractInfinispanTest {
    EmbeddedCacheManager ecm;

    @AfterMethod
    public void cleanup() {
        TestingUtil.killCacheManagers(this.ecm);
        this.ecm = null;
    }

    public void testKeysOnly() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeValuesAsBinary(Boolean.valueOf(false)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        assert (this.ecm.getCache().getConfiguration().isStoreAsBinary());
        assert (this.ecm.getCache().getConfiguration().isStoreKeysAsBinary());
        assert (!this.ecm.getCache().getConfiguration().isStoreValuesAsBinary());
    }

    public void testValuesOnly() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeKeysAsBinary(Boolean.valueOf(false)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        assert (this.ecm.getCache().getConfiguration().isStoreAsBinary());
        assert (!this.ecm.getCache().getConfiguration().isStoreKeysAsBinary());
        assert (this.ecm.getCache().getConfiguration().isStoreValuesAsBinary());
    }

    public void testBoth() {
        Configuration c = new Configuration().fluent().storeAsBinary().build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        assert (this.ecm.getCache().getConfiguration().isStoreAsBinary());
        assert (this.ecm.getCache().getConfiguration().isStoreKeysAsBinary());
        assert (this.ecm.getCache().getConfiguration().isStoreValuesAsBinary());
    }

    public void testConfigCloning() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeKeysAsBinary(Boolean.valueOf(false)).build();
        Configuration clone = c.clone();
        assert (!clone.isStoreKeysAsBinary());
        assert (clone.isStoreValuesAsBinary());
    }

    public void testConfigOverriding() {
        Configuration c = new Configuration().fluent().storeAsBinary().storeKeysAsBinary(Boolean.valueOf(false)).build();
        this.ecm = TestCacheManagerFactory.createCacheManager(c);
        this.ecm.defineConfiguration("newCache", c.clone().fluent().storeAsBinary().storeValuesAsBinary(Boolean.valueOf(false)).storeKeysAsBinary(Boolean.valueOf(true)).build());
        assert (this.ecm.getCache("newCache").getConfiguration().isStoreAsBinary());
        assert (this.ecm.getCache("newCache").getConfiguration().isStoreKeysAsBinary());
        assert (!this.ecm.getCache("newCache").getConfiguration().isStoreValuesAsBinary());
    }
}

