/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.Map;
import org.easymock.classextension.EasyMock;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.notifications.cachelistener.CacheListener;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachelistener.CacheNotifierImplTest")
public class CacheNotifierImplTest
extends AbstractInfinispanTest {
    CacheNotifierImpl n;
    Cache mockCache;
    CacheListener cl;
    InvocationContext ctx;

    @BeforeMethod
    public void setUp() {
        this.n = new CacheNotifierImpl();
        this.mockCache = (Cache)EasyMock.createNiceMock(Cache.class);
        org.easymock.EasyMock.replay((Object[])new Object[]{this.mockCache});
        this.n.injectDependencies(this.mockCache);
        this.cl = new CacheListener();
        this.n.start();
        this.n.addListener((Object)this.cl);
        this.ctx = new NonTxInvocationContext();
    }

    public void testNotifyCacheEntryCreated() {
        this.n.notifyCacheEntryCreated((Object)"k", true, this.ctx);
        this.n.notifyCacheEntryCreated((Object)"k", false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_CREATED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_CREATED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
    }

    public void testNotifyCacheEntryModified() {
        this.n.notifyCacheEntryModified((Object)"k", (Object)"v1", true, this.ctx);
        this.n.notifyCacheEntryModified((Object)"k", (Object)"v2", false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_MODIFIED);
        assert (((CacheEntryModifiedEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (((CacheEntryModifiedEvent)this.cl.getEvents().get(0)).getValue().equals("v1"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_MODIFIED);
        assert (((CacheEntryModifiedEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
        assert (((CacheEntryModifiedEvent)this.cl.getEvents().get(1)).getValue().equals("v2"));
    }

    public void testNotifyCacheEntryRemoved() {
        this.n.notifyCacheEntryRemoved((Object)"k", (Object)"v", true, this.ctx);
        this.n.notifyCacheEntryRemoved((Object)"k", null, false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_REMOVED);
        assert (((CacheEntryRemovedEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (((CacheEntryRemovedEvent)this.cl.getEvents().get(0)).getValue().equals("v"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_REMOVED);
        assert (((CacheEntryRemovedEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
        assert (((CacheEntryRemovedEvent)this.cl.getEvents().get(1)).getValue() == null);
    }

    public void testNotifyCacheEntryVisited() {
        this.n.notifyCacheEntryVisited((Object)"k", (Object)"v", true, this.ctx);
        this.n.notifyCacheEntryVisited((Object)"k", (Object)"v", false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_VISITED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (((CacheEntryVisitedEvent)this.cl.getEvents().get(0)).getValue().equals("v"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_VISITED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
        assert (((CacheEntryVisitedEvent)this.cl.getEvents().get(1)).getValue().equals("v"));
    }

    public void testNotifyCacheEntryEvicted() {
        this.n.notifyCacheEntryEvicted((Object)"k", (Object)"v", null);
        assert (this.cl.isReceivedPost());
        assert (this.cl.getInvocationCount() == 1);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_EVICTED);
        Map entries = ((CacheEntriesEvictedEvent)this.cl.getEvents().get(0)).getEntries();
        Map.Entry entry = entries.entrySet().iterator().next();
        assert (entry.getKey().equals("k"));
        assert (entry.getValue().equals("v"));
    }

    public void testNotifyCacheEntriesEvicted() {
        InternalCacheEntry ice = TestInternalCacheEntryFactory.create("k", "v");
        this.n.notifyCacheEntriesEvicted(Collections.singleton(ice), null);
        assert (this.cl.isReceivedPost());
        assert (this.cl.getInvocationCount() == 1);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_EVICTED);
        Map entries = ((CacheEntriesEvictedEvent)this.cl.getEvents().get(0)).getEntries();
        Map.Entry entry = entries.entrySet().iterator().next();
        assert (entry.getKey().equals("k"));
        assert (entry.getValue().equals("v"));
    }

    public void testNotifyCacheEntryInvalidated() {
        this.n.notifyCacheEntryInvalidated((Object)"k", (Object)"v", true, this.ctx);
        this.n.notifyCacheEntryInvalidated((Object)"k", (Object)"v", false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_INVALIDATED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (((CacheEntryInvalidatedEvent)this.cl.getEvents().get(0)).getValue().equals("v"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_INVALIDATED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
        assert (((CacheEntryInvalidatedEvent)this.cl.getEvents().get(1)).getValue().equals("v"));
    }

    public void testNotifyCacheEntryLoaded() {
        this.n.notifyCacheEntryLoaded((Object)"k", (Object)"v", true, this.ctx);
        this.n.notifyCacheEntryLoaded((Object)"k", (Object)"v", false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_LOADED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (((CacheEntryLoadedEvent)this.cl.getEvents().get(0)).getValue().equals("v"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_LOADED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
        assert (((CacheEntryLoadedEvent)this.cl.getEvents().get(1)).getValue().equals("v"));
    }

    public void testNotifyCacheEntryActivated() {
        this.n.notifyCacheEntryActivated((Object)"k", (Object)"v", true, this.ctx);
        this.n.notifyCacheEntryActivated((Object)"k", (Object)"v", false, this.ctx);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_ACTIVATED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(0)).getKey().equals("k"));
        assert (((CacheEntryActivatedEvent)this.cl.getEvents().get(0)).getValue().equals("v"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_ACTIVATED);
        assert (((CacheEntryEvent)this.cl.getEvents().get(1)).getKey().equals("k"));
        assert (((CacheEntryActivatedEvent)this.cl.getEvents().get(1)).getValue().equals("v"));
    }

    public void testNotifyCacheEntryPassivated() {
        this.n.notifyCacheEntryPassivated((Object)"k", (Object)"v", true, null);
        this.n.notifyCacheEntryPassivated((Object)"k", (Object)"v", false, null);
        assert (this.cl.isReceivedPost());
        assert (this.cl.isReceivedPre());
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.CACHE_ENTRY_PASSIVATED);
        CacheEntryPassivatedEvent event = (CacheEntryPassivatedEvent)this.cl.getEvents().get(0);
        assert (event.getKey().equals("k"));
        assert (event.getValue().equals("v"));
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.CACHE_ENTRY_PASSIVATED);
        event = (CacheEntryPassivatedEvent)this.cl.getEvents().get(1);
        assert (event.getKey().equals("k"));
        assert (event.getValue().equals("v"));
    }

    public void testNotifyTransactionCompleted() {
        GlobalTransaction tx = (GlobalTransaction)EasyMock.createNiceMock(GlobalTransaction.class);
        this.n.notifyTransactionCompleted(tx, true, this.ctx);
        this.n.notifyTransactionCompleted(tx, false, this.ctx);
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.TRANSACTION_COMPLETED);
        assert (((TransactionCompletedEvent)this.cl.getEvents().get(0)).isTransactionSuccessful());
        assert (((TransactionCompletedEvent)this.cl.getEvents().get(0)).getGlobalTransaction() == tx);
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.TRANSACTION_COMPLETED);
        assert (!((TransactionCompletedEvent)this.cl.getEvents().get(1)).isTransactionSuccessful());
        assert (((TransactionCompletedEvent)this.cl.getEvents().get(1)).getGlobalTransaction() == tx);
    }

    public void testNotifyTransactionRegistered() {
        NonTxInvocationContext ctx = new NonTxInvocationContext();
        GlobalTransaction tx = (GlobalTransaction)EasyMock.createNiceMock(GlobalTransaction.class);
        this.n.notifyTransactionRegistered(tx, (InvocationContext)ctx);
        this.n.notifyTransactionRegistered(tx, (InvocationContext)ctx);
        assert (this.cl.getInvocationCount() == 2);
        assert (this.cl.getEvents().get(0).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(0).getType() == Event.Type.TRANSACTION_REGISTERED);
        assert (((TransactionRegisteredEvent)this.cl.getEvents().get(0)).getGlobalTransaction() == tx);
        assert (this.cl.getEvents().get(1).getCache() == this.mockCache);
        assert (this.cl.getEvents().get(1).getType() == Event.Type.TRANSACTION_REGISTERED);
        assert (((TransactionRegisteredEvent)this.cl.getEvents().get(1)).getGlobalTransaction() == tx);
    }
}

