/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcManagerImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="remoting.SingleClusterMemberTransportInvokeTest")
public class SingleClusterMemberTransportInvokeTest
extends MultipleCacheManagersTest {
    final String key = "k";
    final String value = "v";
    final String value2 = "v2";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = SingleClusterMemberTransportInvokeTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        this.createClusteredCaches(1, "replSync", c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvokeRemotelyWhenSingleMember() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Transport mockTransport = (Transport)EasyMock.createMock(Transport.class);
        RpcManagerImpl rpcManager = (RpcManagerImpl)TestingUtil.extractComponent(cache1, RpcManager.class);
        Transport originalTransport = TestingUtil.extractComponent(cache1, Transport.class);
        try {
            Address mockAddress1 = (Address)EasyMock.createNiceMock(Address.class);
            ArrayList<Address> memberList = new ArrayList<Address>(1);
            memberList.add(mockAddress1);
            EasyMock.expect((Object)mockTransport.getMembers()).andReturn(memberList).anyTimes();
            EasyMock.expect((Object)mockTransport.getAddress()).andReturn(null).anyTimes();
            rpcManager.setTransport(mockTransport);
            EasyMock.replay((Object[])new Object[]{mockAddress1, mockTransport});
            cache1.put((Object)"k", (Object)"v");
            EasyMock.verify((Object[])new Object[]{mockTransport});
        }
        finally {
            if (rpcManager != null) {
                rpcManager.setTransport(originalTransport);
            }
        }
    }
}

