/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.ReplicationQueueTest")
public class ReplicationQueueTest
extends MultipleCacheManagersTest {
    private static final int REPL_QUEUE_INTERVAL = 5000;
    private static final int REPL_QUEUE_MAX_ELEMENTS = 10;
    long creationTime;

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.setReplicationQueueScheduledExecutorFactoryClass(ReplQueueTestScheduledExecutorFactory.class.getName());
        globalConfiguration.setReplicationQueueScheduledExecutorProperties(ReplQueueTestScheduledExecutorFactory.myProps);
        EmbeddedCacheManager first = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        EmbeddedCacheManager second = TestCacheManagerFactory.createCacheManager(globalConfiguration);
        this.registerCacheManager(new CacheContainer[]{first, second});
        Configuration config = ReplicationQueueTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, true);
        config.setUseReplQueue(true);
        config.setReplQueueInterval(5000L);
        config.setReplQueueMaxElements(10);
        this.creationTime = System.currentTimeMillis();
        this.manager(0).defineConfiguration("replQueue", config);
        Configuration conf2 = config.clone();
        conf2.setUseReplQueue(false);
        this.manager(1).defineConfiguration("replQueue", conf2);
    }

    @Test(dependsOnMethods={"testReplicationBasedOnTime"})
    public void testAppropriateExecutorIsUsed() {
        assert (ReplQueueTestScheduledExecutorFactory.methodCalled);
        assert (ReplQueueTestScheduledExecutorFactory.command != null);
        assert (ReplQueueTestScheduledExecutorFactory.delay == 5000L);
        assert (ReplQueueTestScheduledExecutorFactory.initialDelay == 5000L);
        assert (ReplQueueTestScheduledExecutorFactory.unit == TimeUnit.MILLISECONDS);
    }

    public void testReplicationBasedOnTime() throws InterruptedException {
        Cache cache1 = this.cache(0, "replQueue");
        Cache cache2 = this.cache(1, "replQueue");
        cache1.put((Object)"key", (Object)"value");
        ReplicationQueue replicationQueue = TestingUtil.extractComponent(cache1, ReplicationQueue.class);
        assert (replicationQueue != null);
        assert (replicationQueue.getElementsCount() == 1);
        assert (cache2.get((Object)"key") == null);
        assert (cache1.get((Object)"key").equals("value"));
        ReplQueueTestScheduledExecutorFactory.command.run();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 5000L && cache2.get((Object)"key") == null) {
            Thread.sleep(50L);
        }
        assert (cache2.get((Object)"key").equals("value"));
        assert (replicationQueue.getElementsCount() == 0);
    }

    public void testReplicationBasedOnTimeWithTx() throws Exception {
        Cache cache1 = this.cache(0, "replQueue");
        Cache cache2 = this.cache(1, "replQueue");
        TransactionManager transactionManager = TestingUtil.getTransactionManager(cache1);
        transactionManager.begin();
        cache1.put((Object)"key", (Object)"value");
        transactionManager.commit();
        ReplicationQueue replicationQueue = TestingUtil.extractComponent(cache1, ReplicationQueue.class);
        assert (replicationQueue != null);
        assert (replicationQueue.getElementsCount() == 1);
        assert (cache2.get((Object)"key") == null);
        assert (cache1.get((Object)"key").equals("value"));
        ReplQueueTestScheduledExecutorFactory.command.run();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 5000L && cache2.get((Object)"key") == null) {
            Thread.sleep(50L);
        }
        assert (cache2.get((Object)"key").equals("value"));
        assert (replicationQueue.getElementsCount() == 0);
    }

    public void testReplicationBasedOnSize() throws Exception {
        Cache cache1 = this.cache(0, "replQueue");
        Cache cache2 = this.cache(1, "replQueue");
        for (int i = 0; i < 10; ++i) {
            cache1.put((Object)("key" + i), (Object)("value" + i));
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 3000L && cache2.size() != 10) {
            Thread.sleep(50L);
        }
        for (int i = 0; i < 10; ++i) {
            assert (cache2.get((Object)("key" + i)).equals("value" + i));
        }
    }

    public void testReplicationBasedOnSizeWithTx() throws Exception {
        Cache cache1 = this.cache(0, "replQueue");
        Cache cache2 = this.cache(1, "replQueue");
        TransactionManager transactionManager = TestingUtil.getTransactionManager(cache1);
        for (int i = 0; i < 10; ++i) {
            transactionManager.begin();
            cache1.put((Object)("key" + i), (Object)("value" + i));
            transactionManager.commit();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 3000L && cache2.size() != 10) {
            Thread.sleep(50L);
        }
        for (int i = 0; i < 10; ++i) {
            assert (cache2.get((Object)("key" + i)).equals("value" + i));
        }
    }

    public void testReplicationQueueMultipleThreads() throws Exception {
        final Cache cache1 = this.cache(0, "replQueue");
        Cache cache2 = this.cache(1, "replQueue");
        int numThreads = 5;
        int numLoopsPerThread = 2;
        Thread[] threads = new Thread[numThreads];
        final CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < numThreads; ++i) {
            final int i1 = i;
            threads[i] = new Thread(){
                int index;
                {
                    this.index = i1;
                }

                @Override
                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (int j = 0; j < 2; ++j) {
                        cache1.put((Object)("key" + this.index + "_" + j), (Object)"value");
                    }
                }
            };
            threads[i].start();
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 3000L && cache2.size() != 10) {
            Thread.sleep(50L);
        }
        assert (cache2.size() == 10);
        ReplicationQueue replicationQueue = TestingUtil.extractComponent(cache1, ReplicationQueue.class);
        assert (replicationQueue.getElementsCount() == numThreads * 2 - 10);
    }

    public static class ReplQueueTestScheduledExecutorFactory
    implements ScheduledExecutorFactory {
        static Properties myProps = new Properties();
        static boolean methodCalled = false;
        static Runnable command;
        static long initialDelay;
        static long delay;
        static TimeUnit unit;

        public ScheduledExecutorService getScheduledExecutor(Properties p) {
            Properties toCompareWith = new Properties();
            for (Map.Entry<Object, Object> entry : myProps.entrySet()) {
                toCompareWith.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            toCompareWith.setProperty("componentName", "replicationQueue-thread");
            toCompareWith.setProperty("threadPriority", "" + KnownComponentNames.getDefaultThreadPrio((String)"org.infinispan.executors.replicationQueue"));
            assert (p.equals(toCompareWith)) : "Expected " + p + " but was " + toCompareWith;
            methodCalled = true;
            return new ScheduledThreadPoolExecutor(1){

                @Override
                public ScheduledFuture<?> scheduleWithFixedDelay(Runnable commandP, long initialDelayP, long delayP, TimeUnit unitP) {
                    command = commandP;
                    initialDelay = initialDelayP;
                    delay = delayP;
                    unit = unitP;
                    return null;
                }
            };
        }

        static {
            myProps.put("aaa", "bbb");
            myProps.put("ddd", "ccc");
        }
    }
}

