/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import org.infinispan.Cache;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.test.TestingUtil;

public class StateTransferTestingUtil {
    public static final String A_B_NAME = "a_b_name";
    public static final String A_C_NAME = "a_c_name";
    public static final String A_D_NAME = "a_d_age";
    public static final String A_B_AGE = "a_b_age";
    public static final String A_C_AGE = "a_c_age";
    public static final String A_D_AGE = "a_d_age";
    public static final String JOE = "JOE";
    public static final String BOB = "BOB";
    public static final String JANE = "JANE";
    public static final Integer TWENTY = 20;
    public static final Integer FORTY = 40;

    public static void verifyNoDataOnLoader(Cache<Object, Object> c) throws Exception {
        CacheLoader l = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheLoader();
        assert (!l.containsKey((Object)A_B_AGE));
        assert (!l.containsKey((Object)A_B_NAME));
        assert (!l.containsKey((Object)A_C_AGE));
        assert (!l.containsKey((Object)A_C_NAME));
        assert (!l.containsKey((Object)"a_d_age"));
        assert (!l.containsKey((Object)"a_d_age"));
    }

    public static void verifyNoData(Cache<Object, Object> c) {
        assert (c.isEmpty()) : "Cache should be empty!";
    }

    public static void writeInitialData(Cache<Object, Object> c) {
        c.put((Object)A_B_NAME, (Object)JOE);
        c.put((Object)A_B_AGE, (Object)TWENTY);
        c.put((Object)A_C_NAME, (Object)BOB);
        c.put((Object)A_C_AGE, (Object)FORTY);
        c.evict((Object)A_B_NAME);
        c.evict((Object)A_B_AGE);
        c.evict((Object)A_C_NAME);
        c.evict((Object)A_C_AGE);
        c.evict((Object)"a_d_age");
        c.evict((Object)"a_d_age");
    }

    public static void verifyInitialDataOnLoader(Cache<Object, Object> c) throws Exception {
        CacheLoader l = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheLoader();
        assert (l.containsKey((Object)A_B_AGE));
        assert (l.containsKey((Object)A_B_NAME));
        assert (l.containsKey((Object)A_C_AGE));
        assert (l.containsKey((Object)A_C_NAME));
        assert (l.load((Object)A_B_AGE).getValue().equals(TWENTY));
        assert (l.load((Object)A_B_NAME).getValue().equals(JOE));
        assert (l.load((Object)A_C_AGE).getValue().equals(FORTY));
        assert (l.load((Object)A_C_NAME).getValue().equals(BOB));
    }

    public static void verifyInitialData(Cache<Object, Object> c) {
        assert (JOE.equals(c.get((Object)A_B_NAME))) : "Incorrect value for key a_b_name";
        assert (TWENTY.equals(c.get((Object)A_B_AGE))) : "Incorrect value for key a_b_age";
        assert (BOB.equals(c.get((Object)A_C_NAME))) : "Incorrect value for key a_c_name";
        assert (FORTY.equals(c.get((Object)A_C_AGE))) : "Incorrect value for key a_c_age";
    }
}

