/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.IClass;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class UnitTestTestNGListener
implements ITestListener,
IInvokedMethodListener {
    private ThreadLocal<IClass> threadTestClass = new ThreadLocal();
    private static final Log log = LogFactory.getLog(UnitTestTestNGListener.class);
    private AtomicInteger failed = new AtomicInteger(0);
    private AtomicInteger succeeded = new AtomicInteger(0);
    private AtomicInteger skipped = new AtomicInteger(0);

    public void onTestStart(ITestResult res) {
        log.info((Object)("Starting test " + this.getTestDesc(res)));
        this.threadTestClass.set(res.getTestClass());
    }

    public synchronized void onTestSuccess(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " succeeded.");
        log.info((Object)("Test succeeded " + this.getTestDesc(arg0) + "."));
        this.succeeded.incrementAndGet();
        this.printStatus();
    }

    public synchronized void onTestFailure(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " failed.");
        if (arg0.getThrowable() != null) {
            log.error((Object)("Test failed " + this.getTestDesc(arg0)), arg0.getThrowable());
        }
        this.failed.incrementAndGet();
        this.printStatus();
    }

    public synchronized void onTestSkipped(ITestResult arg0) {
        System.out.println(this.getThreadId() + " Test " + this.getTestDesc(arg0) + " skipped.");
        log.info((Object)(" Test " + this.getTestDesc(arg0) + " skipped."));
        if (arg0.getThrowable() != null) {
            log.error((Object)("Test skipped : " + arg0.getThrowable()), arg0.getThrowable());
        }
        this.skipped.incrementAndGet();
        this.printStatus();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onStart(ITestContext arg0) {
        String fullName = arg0.getName();
        String simpleName = fullName.substring(fullName.lastIndexOf(46) + 1);
        TestCacheManagerFactory.testStarted(simpleName, fullName);
    }

    public void onFinish(ITestContext arg0) {
        TestCacheManagerFactory.testFinished(arg0.getName());
    }

    private String getThreadId() {
        return "[" + Thread.currentThread().getName() + "]";
    }

    private String getTestDesc(ITestResult res) {
        return res.getMethod().getMethodName() + "(" + res.getTestClass().getName() + ")";
    }

    private void printStatus() {
        System.out.println("Test suite progress: tests succeeded: " + this.succeeded.get() + ", failed: " + this.failed.get() + ", skipped: " + this.skipped.get() + ".");
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!method.isTestMethod()) {
            return;
        }
        if (testResult.getThrowable() != null) {
            log.errorf(testResult.getThrowable(), "Method %s threw an exception", (Object)this.getTestDesc(testResult));
        }
    }
}

