/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.FailureWith1PCTest")
public class FailureWith1PCTest
extends MultipleCacheManagersTest {
    boolean fail = true;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = FailureWith1PCTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        c.fluent().hash().numOwners(Integer.valueOf(3));
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    public void testInducedFailureOn1pc() throws Exception {
        this.cache(1).getAdvancedCache().addInterceptor(new CommandInterceptor(){

            public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
                if (FailureWith1PCTest.this.fail) {
                    throw new RuntimeException("Induced exception");
                }
                return this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
            }
        }, 1);
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v");
        try {
            this.tm(0).commit();
            assert (false) : "Exception expected";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fail = false;
        this.assertExpectedState(0);
        this.assertExpectedState(1);
        this.assertExpectedState(2);
    }

    private void assertExpectedState(int index) {
        Assert.assertNull((Object)this.cache(index).get((Object)"k"));
        assert (!this.lockManager(index).isLocked((Object)"k"));
        assert (TestingUtil.getTransactionTable(this.cache(index)).getLocalTxCount() == 0);
        assert (TestingUtil.getTransactionTable(this.cache(index)).getRemoteTxCount() == 0);
    }
}

