/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(testName="tx.LargeTransactionTest", groups={"functional"})
public class LargeTransactionTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(LargeTransactionTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(true);
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setSyncReplTimeout(30000L);
        c.setLockAcquisitionTimeout(60000L);
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setUseLockStriping(false);
        c.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        EmbeddedCacheManager container = TestCacheManagerFactory.createClusteredCacheManager(c);
        container.start();
        this.registerCacheManager(new CacheContainer[]{container});
        container.startCaches(new String[]{"___defaultcache", "TestCache"});
        Cache cache1 = container.getCache("TestCache");
        assert (cache1.getConfiguration().getCacheMode().equals((Object)Configuration.CacheMode.REPL_SYNC));
        cache1.start();
        container = TestCacheManagerFactory.createClusteredCacheManager(c);
        container.start();
        this.registerCacheManager(new CacheContainer[]{container});
        container.startCaches(new String[]{"___defaultcache", "TestCache"});
        Cache cache2 = container.getCache("TestCache");
        assert (cache2.getConfiguration().getCacheMode().equals((Object)Configuration.CacheMode.REPL_SYNC));
    }

    public void testLargeTx() throws Exception {
        int i;
        Cache cache1 = this.cache(0, "TestCache");
        Cache cache2 = this.cache(1, "TestCache");
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        tm.begin();
        for (i = 0; i < 200; ++i) {
            cache1.put((Object)("key" + i), (Object)("value" + i));
        }
        log.trace((Object)"___________ before commit");
        tm.commit();
        for (i = 0; i < 200; ++i) {
            assert (cache2.get((Object)("key" + i)).equals("value" + i));
        }
    }

    public void testSinglePutInTx() throws Exception {
        Cache cache1 = this.cache(0, "TestCache");
        Cache cache2 = this.cache(1, "TestCache");
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        tm.begin();
        cache1.put((Object)"key", (Object)"val");
        log.trace((Object)"___________ before commit");
        tm.commit();
        assert (cache2.get((Object)"key").equals("val"));
    }

    public void testSimplePutNoTx() {
        Cache cache1 = this.cache(0, "TestCache");
        Cache cache2 = this.cache(1, "TestCache");
        cache1.put((Object)"key", (Object)"val");
        assert (cache2.get((Object)"key").equals("val"));
    }
}

