/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ReadOnlyTxTest")
@CleanupAfterMethod
public class ReadOnlyTxTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration configuration = ReadOnlyTxTest.getDefaultClusteredConfig(Configuration.CacheMode.LOCAL, true);
        return new DefaultCacheManager(configuration);
    }

    public void testSimpleReadOnlTx() throws Exception {
        this.tm().begin();
        assert (this.cache.get((Object)"k") == null);
        Transaction transaction = this.tm().suspend();
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.txTable().getLocalTransaction(transaction);
        assert (localTransaction != null && localTransaction.isReadOnly());
    }

    public void testNotROWhenHasWrites() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k", (Object)"v");
        assert (!TestingUtil.extractLockManager(this.cache).isLocked((Object)"k"));
        Transaction transaction = this.tm().suspend();
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.txTable().getLocalTransaction(transaction);
        assert (localTransaction != null && !localTransaction.isReadOnly());
    }

    public void testNotROWhenHasOnlyLocks() throws Exception {
        this.cache.put((Object)"k", (Object)"v");
        this.tm().begin();
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}).get((Object)"k");
        assert (!TestingUtil.extractLockManager(this.cache).isLocked((Object)"k"));
        Transaction transaction = this.tm().suspend();
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.txTable().getLocalTransaction(transaction);
        assert (localTransaction != null && !localTransaction.isReadOnly());
    }

    private TransactionTable txTable() {
        return TestingUtil.getTransactionTable((Cache<Object, Object>)this.cache);
    }
}

