/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.RemoteLockCleanupTest")
public class RemoteLockCleanupTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = RemoteLockCleanupTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        config.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        super.createClusteredCaches(2, config);
    }

    public void testLockCleanup() throws Exception {
        final DelayInterceptor interceptor = new DelayInterceptor();
        this.advancedCache(0).addInterceptor((CommandInterceptor)interceptor, 1);
        final Object k = this.getKeyForCache(0);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    RemoteLockCleanupTest.this.tm(1).begin();
                    RemoteLockCleanupTest.this.advancedCache(1).lock(new Object[]{k});
                    RemoteLockCleanupTest.this.tm(1).suspend();
                }
                catch (Exception e) {
                    RemoteLockCleanupTest.this.log.error((Object)e);
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return interceptor.receivedReplRequest;
            }
        });
        TestingUtil.killCacheManagers(this.manager(1));
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0));
        TestingUtil.waitForRehashToComplete(this.cache(0));
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return interceptor.lockAcquired;
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !TestingUtil.extractLockManager(RemoteLockCleanupTest.this.cache(0)).isLocked((Object)"k");
            }
        });
    }

    public static class DelayInterceptor
    extends CommandInterceptor {
        volatile boolean receivedReplRequest = false;
        volatile boolean lockAcquired = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                this.receivedReplRequest = true;
                Thread.sleep(5000L);
                try {
                    Object object = super.visitLockControlCommand(ctx, command);
                    return object;
                }
                finally {
                    this.lockAcquired = true;
                }
            }
            return super.visitLockControlCommand(ctx, command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            try {
                Object object = super.visitRollbackCommand(ctx, command);
                return object;
            }
            finally {
                System.out.println("RemoteLockCleanupTest$DelayInterceptor.visitRollbackCommand");
            }
        }
    }
}

