/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import java.util.concurrent.Executor;
import javax.transaction.SystemException;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.RndKeyGenerator;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tx.dld.BaseDldPessimisticLockingTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.dld.DldEagerLockingDistributedTest")
public class DldPessimisticLockingDistributedTest
extends BaseDldPessimisticLockingTest {
    private KeyAffinityService cas;
    private Object k0;
    private Object k1;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = this.createConfiguration();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createCacheManager(config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createCacheManager(config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.waitForClusterToForm();
        this.cas = KeyAffinityServiceFactory.newKeyAffinityService(this.cache(0), (Executor)new Executor(){

            @Override
            public void execute(Runnable command) {
                new Thread(command).start();
            }
        }, (KeyGenerator)new RndKeyGenerator(), (int)2, (boolean)true);
        this.k0 = this.cas.getKeyForAddress(this.address(0));
        this.k1 = this.cas.getKeyForAddress(this.address(1));
        this.cas.stop();
    }

    protected Configuration createConfiguration() {
        Configuration config = DldPessimisticLockingDistributedTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        config.setUnsafeUnreliableReturnValues(true);
        config.setNumOwners(1);
        config.setEnableDeadlockDetection(true);
        config.setUseEagerLocking(true);
        return config;
    }

    public void testSymmetricDeadlock() throws SystemException {
        this.testSymmetricDld(this.k0, this.k1);
    }
}

