/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.xa.Xid;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.SimpleCacheRecoveryAdminTest")
@CleanupAfterMethod
public class SimpleCacheRecoveryAdminTest
extends AbstractRecoveryTest {
    private MBeanServer threadMBeanServer;
    private static final String JMX_DOMAIN = "tx.recovery.admin.LocalCacheRecoveryAdminTest";
    private DummyTransaction tx1;

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        globalConfiguration.fluent().globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup()).jmxDomain(JMX_DOMAIN).allowDuplicateDomains(Boolean.valueOf(true));
        Configuration configuration = SimpleCacheRecoveryAdminTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true).fluent().transaction().transactionManagerLookupClass(RecoveryDummyTransactionManagerLookup.class).recovery().jmxStatistics().locking().useLockStriping(Boolean.valueOf(false)).clustering().hash().numOwners(Integer.valueOf(3)).clustering().l1().disable().build();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration, true);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration, true);
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration, true);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.cache(0, "test");
        this.cache(1, "test");
        this.cache(2, "test");
        TestingUtil.waitForRehashToComplete(this.caches("test"));
        this.threadMBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        assert (this.showInDoubtTransactions(0).isEmpty());
        assert (this.showInDoubtTransactions(1).isEmpty());
        assert (this.showInDoubtTransactions(2).isEmpty());
        this.tx1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(2, "test"));
        RecoveryTestUtil.prepareTransaction(this.tx1);
        this.log.trace((Object)("Shutting down a cache " + this.address(this.cache(2, "test"))));
        TestingUtil.killCacheManagers(this.manager(2));
        TestingUtil.blockUntilViewsReceived(90000L, false, this.cache(0, "test"), this.cache(1, "test"));
    }

    public void testForceCommitOnOtherNode() throws Exception {
        String inDoubt = this.showInDoubtTransactions(0);
        this.assertInDoubtTxCount(inDoubt, 1);
        this.assertInDoubtTxCount(this.showInDoubtTransactions(1), 1);
        List<Long> ids = this.getInternalIds(inDoubt);
        Assert.assertEquals((int)1, (int)ids.size());
        Assert.assertEquals((int)0, (int)this.cache(0, "test").keySet().size());
        Assert.assertEquals((int)0, (int)this.cache(1, "test").keySet().size());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Before forcing commit!");
        }
        String result = this.invokeForceWithId("forceCommit", 0, ids.get(0));
        this.checkResponse(result, 1);
    }

    public void testForceCommitXid() {
        String s = this.invokeForceWithXid("forceCommit", 0, this.tx1.getXid());
        System.out.println("s = " + s);
        this.checkResponse(s, 1);
        s = this.invokeForceWithXid("forceCommit", 0, this.tx1.getXid());
        assert (s.indexOf("Transaction not found") >= 0);
    }

    public void testForceRollbackInternalId() {
        List<Long> ids = this.getInternalIds(this.showInDoubtTransactions(0));
        this.log.tracef("test:: invoke rollback for %s", ids);
        String result = this.invokeForceWithId("forceRollback", 0, ids.get(0));
        System.out.println("result = " + result);
        this.checkResponse(result, 0);
        assert (this.invokeForceWithId("forceRollback", 0, ids.get(0)).contains("Transaction not found"));
    }

    public void testForceRollbackXid() {
        String s = this.invokeForceWithXid("forceRollback", 0, this.tx1.getXid());
        System.out.println("s = " + s);
        this.checkResponse(s, 0);
        s = this.invokeForceWithXid("forceRollback", 0, this.tx1.getXid());
        assert (s.indexOf("Transaction not found") >= 0);
    }

    private void checkResponse(String result, int entryCount) {
        assert (this.isSuccess(result)) : "Received: " + result;
        Assert.assertEquals((int)this.cache(0, "test").keySet().size(), (int)entryCount);
        Assert.assertEquals((int)this.cache(1, "test").keySet().size(), (int)entryCount);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return SimpleCacheRecoveryAdminTest.this.showInDoubtTransactions(0).isEmpty() && SimpleCacheRecoveryAdminTest.this.showInDoubtTransactions(1).isEmpty();
            }
        });
        this.checkProperlyCleanup(0);
        this.checkProperlyCleanup(1);
    }

    @Override
    protected void checkProperlyCleanup(final int managerIndex) {
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return TestingUtil.extractLockManager(SimpleCacheRecoveryAdminTest.this.cache(managerIndex, "test")).getNumberOfLocksHeld() == 0;
            }
        });
        final TransactionTable tt = TestingUtil.extractComponent(this.cache(managerIndex, "test"), TransactionTable.class);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return tt.getRemoteTxCount() == 0 && tt.getLocalTxCount() == 0;
            }
        });
        RecoveryManager rm = TestingUtil.extractComponent(this.cache(managerIndex, "test"), RecoveryManager.class);
        Assert.assertEquals((int)rm.getInDoubtTransactions().size(), (int)0);
        Assert.assertEquals((int)rm.getPreparedTransactionsFromCluster().all().length, (int)0);
    }

    private String invokeForceWithId(String methodName, int cacheIndex, Long aLong) {
        try {
            ObjectName recoveryAdmin = this.getRecoveryAdminObjectName(cacheIndex);
            return this.threadMBeanServer.invoke(recoveryAdmin, methodName, new Object[]{aLong}, new String[]{Long.TYPE.getName()}).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String invokeForceWithXid(String methodName, int cacheIndex, Xid xid) {
        try {
            ObjectName recoveryAdmin = this.getRecoveryAdminObjectName(cacheIndex);
            Object[] params = new Object[]{xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()};
            String[] signature = new String[]{Integer.TYPE.getName(), byte[].class.getName(), byte[].class.getName()};
            return this.threadMBeanServer.invoke(recoveryAdmin, methodName, params, signature).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertInDoubtTxCount(String inDoubt, int expectedCount) {
        int count = this.countInDoubtTx(inDoubt);
        Assert.assertEquals((int)expectedCount, (int)count);
    }

    private String showInDoubtTransactions(int cacheIndex) {
        try {
            ObjectName recoveryAdmin = this.getRecoveryAdminObjectName(cacheIndex);
            return (String)this.threadMBeanServer.invoke(recoveryAdmin, "showInDoubtTransactions", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName getRecoveryAdminObjectName(int cacheIndex) throws Exception {
        String postfix = cacheIndex == 0 ? "" : String.valueOf(++cacheIndex);
        return TestingUtil.getCacheObjectName(JMX_DOMAIN + postfix, "test(dist_sync)", "RecoveryAdmin");
    }
}

